/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.adobe.acs.commons.images.NamedImageTransformer;
import com.adobe.acs.commons.util.OsgiPropertyUtil;
import com.adobe.acs.commons.util.TypeUtil;
import com.adobe.acs.commons.wcm.ComponentHelper;
import com.day.image.Layer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Named Image Transformer Factory", description="Instances of this factory define registered Named Image transformers which are comprised of ordered, parameter-ized image transformers.", configurationFactory=true, metatype=true)
@Reference(name="imageTransformers", referenceInterface=ImageTransformer.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
@Service
public class NamedImageTransformerImpl
implements NamedImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(NamedImageTransformerImpl.class);
    private Map<String, ImageTransformer> imageTransformers = new HashMap<String, ImageTransformer>();
    @Reference
    private ComponentHelper componentHelper;
    private static final String DEFAULT_TRANSFORM_NAME = "";
    @Property(label="Transform Name", description="Name of Transform.", value={""})
    private static final String PROP_NAME = "name";
    private String transformName = "";
    @Property(label="Image Transformers", description="Transform in the format [ image-transformer-type:key1=val1&key2=val2 ] Order of transform rules dictates order of application.", cardinality=0x7FFFFFFF, value={})
    private static final String PROP_TRANSFORMS = "transforms";
    private Map<String, ValueMap> transforms = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public final Layer transform(Layer layer) {
        for (String type : this.transforms.keySet()) {
            ImageTransformer imageTransformer = this.imageTransformers.get(type);
            if (imageTransformer == null) {
                log.warn("Skipping transform. Missing ImageTransformer for type: {}");
                continue;
            }
            ValueMap transformParams = this.transforms.get(type);
            layer = imageTransformer.transform(layer, transformParams);
        }
        return layer;
    }

    @Override
    public final Map<String, ValueMap> getImageTransforms() {
        return this.transforms;
    }

    @Activate
    protected final void activate(Map<String, String> properties) throws Exception {
        this.transformName = PropertiesUtil.toString((Object)properties.get(PROP_NAME), (String)DEFAULT_TRANSFORM_NAME);
        log.info("Registering Named Image Transformer: {}", (Object)this.transformName);
        Map<String, String> map = OsgiPropertyUtil.toMap(PropertiesUtil.toStringArray((Object)properties.get(PROP_TRANSFORMS), (String[])new String[0]), ":", true, null);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] params = StringUtils.split((String)entry.getValue(), (String)"&");
            Map<String, String> values = OsgiPropertyUtil.toMap(params, "=", true, null);
            log.debug("ImageTransform params for [ {} ] ~> {}", (Object)entry.getKey(), values);
            this.transforms.put(entry.getKey(), TypeUtil.toValueMap(values));
        }
        log.info("Named Images Transforms: {}", (Object)this.transforms.size());
        for (Map.Entry<String, String> entry : this.transforms.entrySet()) {
            log.info("{} ~> {}", (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    protected final void bindImageTransformers(ImageTransformer service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("type"), null);
        if (type != null) {
            this.imageTransformers.put(type, service);
        }
    }

    protected final void unbindImageTransformers(ImageTransformer service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("type"), null);
        if (type != null) {
            this.imageTransformers.remove(type);
        }
    }

    protected void bindComponentHelper(ComponentHelper componentHelper) {
        this.componentHelper = componentHelper;
    }

    protected void unbindComponentHelper(ComponentHelper componentHelper) {
        if (this.componentHelper == componentHelper) {
            this.componentHelper = null;
        }
    }
}

