/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.day.image.Layer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Image Transformer - RGB Shift")
@Properties(value={@Property(name="type", value={"rgb-shift"}, propertyPrivate=true)})
@Service
public class RGBShiftImageTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(RGBShiftImageTransformerImpl.class);
    static final String TYPE = "rgb-shift";
    private static final String KEY_RED = "red";
    private static final String KEY_RED_ALIAS = "r";
    private static final String KEY_GREEN = "green";
    private static final String KEY_GREEN_ALIAS = "g";
    private static final String KEY_BLUE = "blue";
    private static final String KEY_BLUE_ALIAS = "b";
    private static final double DEFAULT_SHIFT_VALUE = 0.0;
    private static final float MAX_SHIFT_VALUE = 1.0f;
    private static final float MIN_SHIFT_VALUE = -1.0f;
    private static final int MIN_COLOR_VALUE = 0;
    private static final int MAX_COLOR_VALUE = 255;

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)TYPE);
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)TYPE);
        float red = this.normalizeRGB(((Double)properties.get(KEY_RED, properties.get(KEY_RED_ALIAS, (Object)0.0))).floatValue());
        float green = this.normalizeRGB(((Double)properties.get(KEY_GREEN, properties.get(KEY_GREEN_ALIAS, (Object)0.0))).floatValue());
        float blue = this.normalizeRGB(((Double)properties.get(KEY_BLUE, properties.get(KEY_BLUE_ALIAS, (Object)0.0))).floatValue());
        int redShift = Math.round(red * 255.0f);
        int greenShift = Math.round(green * 255.0f);
        int blueShift = Math.round(blue * 255.0f);
        BufferedImage image = this.shift(layer.getImage(), redShift, greenShift, blueShift);
        Layer result = new Layer(image);
        return result;
    }

    private BufferedImage shift(BufferedImage original, int redShift, int greenShift, int blueShift) {
        BufferedImage updated = new BufferedImage(original.getWidth(), original.getHeight(), 2);
        for (int x = 0; x < original.getWidth(); ++x) {
            for (int y = 0; y < original.getHeight(); ++y) {
                Color pixel = new Color(original.getRGB(x, y));
                int red = pixel.getRed() + redShift;
                if (red > 255) {
                    red = 255;
                } else if (red < 0) {
                    red = 0;
                }
                int green = pixel.getGreen() + greenShift;
                if (green > 255) {
                    green = 255;
                } else if (green < 0) {
                    green = 0;
                }
                int blue = pixel.getBlue() + blueShift;
                if (blue > 255) {
                    blue = 255;
                } else if (blue < 0) {
                    blue = 0;
                }
                Color shifted = new Color(red, green, blue);
                updated.setRGB(x, y, shifted.getRGB());
            }
        }
        return updated;
    }

    private float normalizeRGB(float rgbValue) {
        if (rgbValue > 1.0f) {
            rgbValue = 1.0f;
        } else if (rgbValue < -1.0f) {
            rgbValue = -1.0f;
        }
        return rgbValue;
    }
}

