/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.day.image.Layer;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Image Transformer - Resize", description="ImageTransformer that resizes the layer. Accepts two Integer params: height and width.If either is left blank the missing dimension will be computed based on the original layer's aspect ratio")
@Properties(value={@Property(name="type", value={"resize"}, propertyPrivate=true)})
@Service
public class ResizeImageTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(ResizeImageTransformerImpl.class);
    static final String TYPE = "resize";
    private static final String KEY_WIDTH = "width";
    private static final String KEY_WIDTH_ALIAS = "w";
    private static final String KEY_HEIGHT = "height";
    private static final String KEY_HEIGHT_ALIAS = "h";
    private static final int DEFAULT_MAX_DIMENSION = 50000;
    private int maxDimension = 50000;
    @Property(label="Max dimension in px", description="Maximum size height and width can be re-sized to. [ Default: 50000 ]", intValue={50000})
    public static final String PROP_MAX_DIMENSION = "max-dimension";

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)TYPE);
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)TYPE);
        int width = (Integer)properties.get(KEY_WIDTH, properties.get(KEY_WIDTH_ALIAS, (Object)0));
        int height = (Integer)properties.get(KEY_HEIGHT, properties.get(KEY_HEIGHT_ALIAS, (Object)0));
        if (width > this.maxDimension) {
            width = this.maxDimension;
        }
        if (height > this.maxDimension) {
            height = this.maxDimension;
        }
        if (width < 1 && height < 1) {
            width = layer.getWidth();
            height = layer.getHeight();
        } else if (width < 1) {
            float aspect = (float)height / (float)layer.getHeight();
            width = Math.round((float)layer.getWidth() * aspect);
        } else if (height < 1) {
            float aspect = (float)width / (float)layer.getWidth();
            height = Math.round((float)layer.getHeight() * aspect);
        }
        layer.resize(width, height);
        return layer;
    }

    @Activate
    protected final void activate(Map<String, String> config) {
        this.maxDimension = PropertiesUtil.toInteger((Object)config.get(PROP_MAX_DIMENSION), (int)50000);
    }
}

