/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.rewriter.impl;

import com.adobe.acs.commons.rewriter.AbstractTransformer;
import com.day.cq.commons.PathInfo;
import com.day.cq.widget.HtmlLibrary;
import com.day.cq.widget.HtmlLibraryManager;
import com.day.cq.widget.LibraryType;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Component(label="ACS AEM Commons - Versioned Clientlibs (CSS/JS) Rewriter", description="Re-writes paths to CSS and JS clientlibs to include the md5 checksum as a selector; in the form: /path/to/clientlib.123456789.css")
@Property(name="pipeline.type", value={"versioned-clientlibs"}, propertyPrivate=true)
@Service
public final class VersionedClientlibsTransformerFactory
implements TransformerFactory {
    private static final Logger log = LoggerFactory.getLogger(VersionedClientlibsTransformerFactory.class);
    private static final String ATTR_JS_PATH = "src";
    private static final String ATTR_CSS_PATH = "href";
    private static final String CSS_TYPE = "text/css";
    private static final String JS_TYPE = "text/javascript";
    @Reference
    private HtmlLibraryManager htmlLibraryManager;

    public Transformer createTransformer() {
        return new VersionableClientlibsTransformer();
    }

    private Attributes versionClientLibs(String elementName, Attributes attrs) {
        if (this.isCSS(elementName, attrs)) {
            return this.rebuildAttributes(new AttributesImpl(attrs), attrs.getIndex("", ATTR_CSS_PATH), attrs.getValue("", ATTR_CSS_PATH), LibraryType.CSS);
        }
        if (this.isJavaScript(elementName, attrs)) {
            return this.rebuildAttributes(new AttributesImpl(attrs), attrs.getIndex("", ATTR_JS_PATH), attrs.getValue("", ATTR_JS_PATH), LibraryType.JS);
        }
        return attrs;
    }

    private Attributes rebuildAttributes(AttributesImpl newAttributes, int index, String path, LibraryType libraryType) {
        String versionedPath = this.getVersionedPath(path, libraryType);
        if (StringUtils.isNotBlank((String)versionedPath)) {
            log.debug("Rewriting to: {}", (Object)versionedPath);
            newAttributes.setValue(index, versionedPath);
        } else {
            log.debug("Versioned Path could not be created properly");
        }
        return newAttributes;
    }

    private boolean isCSS(String elementName, Attributes attrs) {
        String rel = attrs.getValue("", "rel");
        String type = attrs.getValue("", "type");
        String href = attrs.getValue("", ATTR_CSS_PATH);
        return StringUtils.equals((String)"link", (String)elementName) && StringUtils.equals((String)rel, (String)"stylesheet") && StringUtils.equals((String)type, (String)CSS_TYPE) && StringUtils.startsWith((String)href, (String)"/") && !StringUtils.startsWith((String)href, (String)"//") && StringUtils.endsWith((String)href, (String)LibraryType.CSS.extension);
    }

    private boolean isJavaScript(String elementName, Attributes attrs) {
        String type = attrs.getValue("", "type");
        String src = attrs.getValue("", ATTR_JS_PATH);
        return StringUtils.equals((String)"script", (String)elementName) && StringUtils.equals((String)type, (String)JS_TYPE) && StringUtils.startsWith((String)src, (String)"/") && !StringUtils.startsWith((String)src, (String)"//") && StringUtils.endsWith((String)src, (String)LibraryType.JS.extension);
    }

    private String getVersionedPath(String originalPath, LibraryType libraryType) {
        try {
            PathInfo pathInfo = new PathInfo(originalPath);
            HtmlLibrary htmlLibrary = this.htmlLibraryManager.getLibrary(libraryType, pathInfo.getResourcePath());
            if (htmlLibrary != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(htmlLibrary.getLibraryPath());
                builder.append(".");
                String selector = pathInfo.getSelectorString();
                if (selector != null) {
                    builder.append(selector).append(".");
                }
                builder.append(DigestUtils.md5Hex((InputStream)htmlLibrary.getInputStream()));
                builder.append(libraryType.extension);
                return builder.toString();
            }
            log.debug("Could not find HtmlLibrary at path: {}", (Object)pathInfo.getResourcePath());
            return null;
        }
        catch (Exception ex) {
            log.error("Attempting to get a versioned path for [ {} ] but could not because of: {}", (Object)originalPath, (Object)ex.getMessage());
            return originalPath;
        }
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }

    private class VersionableClientlibsTransformer
    extends AbstractTransformer {
        private VersionableClientlibsTransformer() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            this.getContentHandler().startElement(namespaceURI, localName, qName, VersionedClientlibsTransformerFactory.this.versionClientLibs(localName, attrs));
        }
    }
}

