/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import aQute.bnd.annotation.ProviderType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.joda.time.format.ISODateTimeFormat;

@ProviderType
public class TypeUtil {
    private static final Pattern JSON_DATE = Pattern.compile("^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\.[0-9]{3}[-+]{1}[0-9]{2}[:]{0,1}[0-9]{2}$");

    private TypeUtil() {
    }

    public static <T> Map<T, T> arrayToMap(T[] list) {
        HashMap<T, T> map = new HashMap<T, T>();
        if (list == null) {
            return map;
        }
        if (list.length > 0 && list.length % 2 == 1) {
            throw new IllegalArgumentException("Array must be even in length, representing a series of Key, Value pairs.");
        }
        for (int i = 0; i < list.length; ++i) {
            map.put(list[i], list[++i]);
        }
        return map;
    }

    public static <T> Map<String, T> toMap(JSONObject json, Class<T> klass) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List keys = IteratorUtils.toList((Iterator)json.keys());
        for (Object key : keys) {
            String strKey = key.toString();
            Object obj = json.get(strKey);
            if (!klass.isInstance(obj)) continue;
            map.put(strKey, obj);
        }
        return map;
    }

    public static Map<String, Object> toMap(JSONObject json) throws JSONException {
        return TypeUtil.toMap(json, Object.class);
    }

    public static <T> Class<T> getType(Object object) {
        if (object instanceof Double || object instanceof Float) {
            return Double.class;
        }
        if (object instanceof Number) {
            return Long.class;
        }
        if (object instanceof Boolean) {
            return Boolean.class;
        }
        if (object instanceof String && JSON_DATE.matcher((String)object).matches()) {
            return Date.class;
        }
        return String.class;
    }

    public static <T> T toObjectType(String data, Class<T> klass) {
        if (Double.class.equals(klass)) {
            try {
                return klass.cast(Double.parseDouble(data));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (Long.class.equals(klass)) {
            try {
                return klass.cast(Long.parseLong(data));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (StringUtils.equalsIgnoreCase((String)"true", (String)data)) {
            return klass.cast(Boolean.TRUE);
        }
        if (StringUtils.equalsIgnoreCase((String)"false", (String)data)) {
            return klass.cast(Boolean.FALSE);
        }
        if (JSON_DATE.matcher(data).matches()) {
            return klass.cast(ISODateTimeFormat.dateTimeParser().parseDateTime(data).toDate());
        }
        return klass.cast(data);
    }

    public static String toString(Object obj, Class<?> klass) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return TypeUtil.toString(obj, klass, null);
    }

    public static String toString(Object obj, Class<?> klass, String methodName) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (StringUtils.isBlank((String)methodName)) {
            methodName = "toString";
        }
        Method method = klass.getMethod(methodName, new Class[0]);
        return (String)method.invoke(obj, new Object[0]);
    }

    public static ValueMap toValueMap(Map<String, ?> map) {
        LinkedHashMap objectMap = new LinkedHashMap(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            objectMap.put(entry.getKey(), entry.getValue());
        }
        return new ValueMapDecorator(objectMap);
    }
}

