/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.wcm.ComponentEditType;
import com.adobe.acs.commons.wcm.ComponentHelper;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.ComponentEditConfig;
import com.day.cq.wcm.api.components.DropTarget;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.foundation.Placeholder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;

@Component(label="ACS AEM Commons - Component Helper", description="Component Helper is a service used in the context of CQ Components for encapsulating common tasks and performing common checks.", immediate=false, metatype=true)
@Service
public final class ComponentHelperImpl
implements ComponentHelper {
    private static final String CSS_EDIT_MODE = "wcm-helper-edit-mode";

    @Override
    public String generateClassicUIPlaceholder(String classNames, String title) {
        StringBuilder html = new StringBuilder();
        html.append("<img src=\"/libs/cq/ui/resources/0.gif\" ");
        html.append(" class=\"").append(classNames);
        html.append("\" ");
        if (StringUtils.isNotBlank((String)title)) {
            html.append("alt=\"").append(title).append("\" ");
            html.append("title=\"").append(title).append("\"");
        }
        html.append("/>");
        return html.toString();
    }

    @Override
    public boolean isDesignMode(SlingHttpServletRequest request) {
        return WCMMode.DESIGN.equals((Object)WCMMode.fromRequest((ServletRequest)request));
    }

    @Override
    public boolean isDisabledMode(SlingHttpServletRequest request) {
        return WCMMode.DISABLED.equals((Object)WCMMode.fromRequest((ServletRequest)request));
    }

    @Override
    public boolean isEditMode(SlingHttpServletRequest request) {
        return WCMMode.EDIT.equals((Object)WCMMode.fromRequest((ServletRequest)request));
    }

    @Override
    public boolean isPreviewMode(SlingHttpServletRequest request) {
        return WCMMode.PREVIEW.equals((Object)WCMMode.fromRequest((ServletRequest)request));
    }

    @Override
    public boolean isReadOnlyMode(SlingHttpServletRequest request) {
        return WCMMode.READ_ONLY.equals((Object)WCMMode.fromRequest((ServletRequest)request));
    }

    @Override
    public boolean isAuthoringMode(SlingHttpServletRequest request) {
        return this.isEditMode(request) || this.isDesignMode(request);
    }

    @Override
    public boolean isTouchAuthoringMode(ServletRequest request) {
        return Placeholder.isAuthoringUIModeTouch((ServletRequest)request);
    }

    @Override
    public boolean printEditBlock(SlingHttpServletRequest request, SlingHttpServletResponse response, ComponentEditType.Type editType, boolean ... isConfigured) {
        String html = this.getEditBlock(request, editType, isConfigured);
        if (html == null) {
            return false;
        }
        try {
            response.getWriter().print(html);
            response.getWriter().flush();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean printEditBlockOrNothing(SlingHttpServletRequest request, SlingHttpServletResponse response, ComponentEditType.Type editType, boolean ... isConfigured) {
        if (this.isAuthoringMode(request)) {
            return this.printEditBlock(request, response, editType, isConfigured);
        }
        return !this.conditionAndCheck(isConfigured);
    }

    @Override
    public boolean printDDEditBlock(SlingHttpServletRequest request, SlingHttpServletResponse response, String name, boolean ... isConfigured) {
        return this.printDDEditBlock(request, response, name, null, isConfigured);
    }

    @Override
    public boolean printDDEditBlock(SlingHttpServletRequest request, SlingHttpServletResponse response, String name, ComponentEditType.Type editType, boolean ... isConfigured) {
        String html = this.getDDEditBlock(request, name, editType, isConfigured);
        if (html == null) {
            return false;
        }
        try {
            response.getWriter().print(html);
            response.getWriter().flush();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getEditBlock(SlingHttpServletRequest request, ComponentEditType.Type editType, boolean ... isConfigured) {
        Resource resource = request.getResource();
        com.day.cq.wcm.api.components.Component component = WCMUtils.getComponent((Resource)resource);
        if (!this.isAuthoringMode(request) || this.conditionAndCheck(isConfigured)) {
            return null;
        }
        if (ComponentEditType.NONE.equals(editType)) {
            return "<!-- Edit Mode Placeholder is specified as: " + editType.getName() + " -->";
        }
        StringBuilder html = new StringBuilder("<div class=\"wcm-edit-mode wcm-helper-edit-mode\">");
        if (component == null) {
            html.append(this.getCssStyle());
            html.append("Could not resolve CQ Component type.");
        } else if (ComponentEditType.NOICON.equals(editType) || ComponentEditType.NONE.equals(editType)) {
            String title = StringUtils.capitalize((String)component.getTitle());
            html.append(this.getCssStyle());
            html.append("<dl>");
            html.append("<dt>" + title + " Component</dt>");
            if (component.isEditable()) {
                html.append("<dd>Double click or Right click to Edit</dd>");
            }
            if (component.isDesignable()) {
                html.append("<dd>Switch to Design mode and click the Edit button</dd>");
            }
            if (!component.isEditable() && !component.isDesignable()) {
                html.append("<dd>The component cannot be directly authored</dd>");
            }
            html.append("</dl>");
        } else if (ComponentEditType.DROPTARGETS.equals(editType)) {
            Map dropTargets;
            ComponentEditConfig editConfig = component.getEditConfig();
            Map map = dropTargets = editConfig != null ? editConfig.getDropTargets() : null;
            if (dropTargets != null && !dropTargets.isEmpty()) {
                for (Map.Entry entry : dropTargets.entrySet()) {
                    DropTarget dropTarget = (DropTarget)entry.getValue();
                    html.append("<img src=\"/libs/cq/ui/resources/0.gif\" ");
                    html.append("class=\"").append(dropTarget.getId());
                    html.append(" ").append(this.getWCMEditType(dropTarget).getCssClass()).append("\" ");
                    html.append("alt=\"Drop Target: ").append(dropTarget.getName()).append("\" ");
                    html.append("title=\"Drop Target: ").append(dropTarget.getName()).append("\"/>");
                }
            }
        } else {
            String title = StringUtils.capitalize((String)component.getTitle());
            html.append("<img src=\"/libs/cq/ui/resources/0.gif\" ");
            html.append("class=\"").append(editType.getCssClass()).append("\" alt=\"");
            html.append(title).append("\" ");
            html.append("title=\"").append(title).append("\"/>");
        }
        html.append("</div>");
        return html.toString();
    }

    @Override
    public String getDDEditBlock(SlingHttpServletRequest request, String name, boolean ... isConfigured) {
        return this.getDDEditBlock(request, name, null, isConfigured);
    }

    @Override
    public String getDDEditBlock(SlingHttpServletRequest request, String name, ComponentEditType.Type editType, boolean ... isConfigured) {
        Map dropTargets;
        if (!this.isAuthoringMode(request) || this.conditionAndCheck(isConfigured)) {
            return null;
        }
        Resource resource = request.getResource();
        com.day.cq.wcm.api.components.Component component = WCMUtils.getComponent((Resource)resource);
        StringBuilder html = new StringBuilder();
        ComponentEditConfig editConfig = component.getEditConfig();
        Map map = dropTargets = editConfig != null ? editConfig.getDropTargets() : null;
        if (dropTargets != null && !dropTargets.isEmpty()) {
            Map.Entry entry;
            DropTarget dropTarget = null;
            Iterator i$ = dropTargets.entrySet().iterator();
            while (i$.hasNext() && !StringUtils.equals((String)name, (String)(dropTarget = (DropTarget)(entry = i$.next()).getValue()).getName())) {
                dropTarget = null;
            }
            if (dropTarget != null) {
                editType = editType == null ? this.getWCMEditType(dropTarget) : editType;
                String classNames = dropTarget.getId() + " " + editType.getCssClass();
                String placeholderTitle = "Drop Target: " + dropTarget.getName();
                html.append(this.generateClassicUIPlaceholder(classNames, placeholderTitle));
            }
        }
        return html.toString();
    }

    @Override
    public String getEditIconImgTag(ComponentEditType.Type editType) {
        String title = StringUtils.capitalize((String)editType.getName());
        return "<img src=\"/libs/cq/ui/resources/0.gif\" class=\"" + editType.getCssClass() + "\"" + " " + "alt=\"" + title + "\" " + "title=\"" + title + "\" />";
    }

    private ComponentEditType.Type getWCMEditType(DropTarget dropTarget) {
        if (dropTarget == null) {
            return ComponentEditType.NONE;
        }
        List<String> groups = Arrays.asList(dropTarget.getGroups());
        List<String> accepts = Arrays.asList(dropTarget.getAccept());
        if (groups.isEmpty() && accepts.isEmpty()) {
            return ComponentEditType.NONE;
        }
        if (groups.contains("media")) {
            if (this.matches(accepts, "image")) {
                return ComponentEditType.IMAGE;
            }
            if (this.matches(accepts, "video")) {
                return ComponentEditType.VIDEO;
            }
            if (this.matches(accepts, "flash")) {
                return ComponentEditType.FLASH;
            }
            if (accepts.size() == 1 && ".*".equals(accepts.get(0))) {
                return ComponentEditType.FILE;
            }
        } else {
            if (groups.contains("page")) {
                return ComponentEditType.REFERENCE;
            }
            if (groups.contains("paragraph")) {
                return ComponentEditType.REFERENCE;
            }
        }
        return ComponentEditType.TEXT;
    }

    private boolean matches(List<String> list, String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return false;
        }
        for (String item : list) {
            if (item == null || !item.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean conditionAndCheck(boolean ... conditions) {
        if (conditions == null) {
            return false;
        }
        for (int i = 0; i < conditions.length; ++i) {
            if (conditions[i]) continue;
            return false;
        }
        return true;
    }

    private String getCssStyle() {
        String css = "";
        css = css + "<style>";
        css = css + ".wcm-helper-edit-mode { border:dashed 2px #ccc; color:#ccc; padding:1em; }";
        css = css + ".wcm-helper-edit-mode dt { font-weight: bold; }";
        css = css + ".wcm-helper-edit-mode dd { display:list-item; list-style-type:disc; margin-left:1.5em; }";
        css = css + "</style>";
        return css;
    }
}

