/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - File Importer", description="Importer which can import a file from the file system into the content repository.", metatype=true)
@Service
@Property(label="Display Name", description="Label which will be displayed in the Polling Importer Add... dialog", name="displayName", value={"File"})
public final class FileImporter
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(FileImporter.class);
    private static final String DEFAULT_SCHEME = "file";
    @Reference
    private MimeTypeService mimeTypeService;
    @Property(label="Importer Scheme", description="Scheme value that will be used for this importer. Must be unique across importers.", value={"file"})
    private static final String PROP_SCHEME = "importer.scheme";
    private String scheme;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.scheme = PropertiesUtil.toString((Object)properties.get(PROP_SCHEME), (String)DEFAULT_SCHEME);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importData(String schemeValue, String dataSource, Resource target) {
        if (!this.scheme.equals(schemeValue)) {
            FileImporter.log.warn("Unrecognized scheme '{}' passed to importData()", (Object)schemeValue);
            return;
        }
        file = new File(dataSource);
        if (!file.exists()) {
            FileImporter.log.warn("File at '{}' does not exist. Skipping import.", (Object)dataSource);
            return;
        }
        fileLastMod = Calendar.getInstance();
        fileLastMod.setTimeInMillis(file.lastModified());
        fileName = file.getName();
        mimeType = this.mimeTypeService.getMimeType(fileName);
        stream = null;
        node = (Node)target.adaptTo(Node.class);
        if (node == null) {
            FileImporter.log.warn("Target '{}' is not a JCR node. Skipping import from '{}'.", (Object)target.getPath(), (Object)dataSource);
            return;
        }
        try {
            if (!node.isNodeType("nt:file")) ** GOTO lbl-1000
            targetParent = node.getParent();
            targetName = node.getName();
            nodeLastMod = JcrUtils.getLastModified((Node)node);
            if (!nodeLastMod.before(fileLastMod)) {
                FileImporter.log.info("File '{}' does not have a newer timestamp than '{}'. Skipping import.", (Object)dataSource, (Object)target);
                if (stream == null) return;
            }
            ** GOTO lbl-1000
        }
        catch (RepositoryException e) {
            try {
                throw new ImportException("Unable to import from file '" + dataSource + "' to '" + target.getPath() + "'", (Throwable)e);
                catch (FileNotFoundException e) {
                    throw new ImportException("Unexpected FileNotFoundException while importing", (Throwable)e);
                }
            }
            catch (Throwable var14_16) {
                if (stream == null) throw var14_16;
                IOUtils.closeQuietly(stream);
                throw var14_16;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return;
lbl-1000:
        // 1 sources

        {
            targetParent = node;
            targetName = fileName;
            if (!targetParent.hasNode(targetName) || (nodeLastMod = JcrUtils.getLastModified((Node)(targetNode = targetParent.getNode(targetName)))).before(fileLastMod)) ** GOTO lbl-1000
            FileImporter.log.info("File '{}' does not have a newer timestamp than '{}'. Skipping import.", (Object)dataSource, (Object)targetNode.getPath());
            if (stream == null) return;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return;
lbl-1000:
        // 2 sources

        {
            stream = new FileInputStream(file);
            JcrUtils.putFile((Node)targetParent, (String)targetName, (String)mimeType, (InputStream)stream);
            node.getSession().save();
            if (stream == null) return;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

