/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.impl;

import com.adobe.acs.commons.workflow.bulk.BulkWorkflowEngine;
import com.adobe.acs.commons.workflow.bulk.impl.Bucket;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Bulk Workflow Engine", immediate=true)
@Service
public class BulkWorkflowEngineImpl
implements BulkWorkflowEngine {
    private static final Logger log = LoggerFactory.getLogger(BulkWorkflowEngineImpl.class);
    private static final int SAVE_THRESHOLD = 1000;
    @Reference
    private WorkflowService workflowService;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private ConcurrentHashMap<String, String> jobs = null;

    @Override
    public final Resource getCurrentBatch(Resource resource) {
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        String currentBatch = (String)properties.get("currentBatch", (Object)"");
        Resource currentBatchResource = resource.getResourceResolver().getResource(currentBatch);
        if (currentBatchResource == null) {
            log.error("Current batch resource [ {} ] could not be located. Cannot process Bulk workflow.", (Object)currentBatch);
        }
        return currentBatchResource;
    }

    @Override
    public final void initialize(Resource resource, ValueMap params) throws PersistenceException, RepositoryException {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        log.trace("Entering initialized");
        if (((Boolean)properties.get("initialized", (Object)false)).booleanValue()) {
            log.warn("Refusing to re-initialize an already initialized Bulk Workflow Manager.");
            return;
        }
        properties.putAll((Map)params);
        properties.put((Object)"jobName", (Object)resource.getPath());
        ResourceResolver resourceResolver = resource.getResourceResolver();
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        QueryResult queryResult = queryManager.createQuery((String)properties.get("query", (Object)""), "JCR-SQL2").execute();
        NodeIterator nodes = queryResult.getNodes();
        long size = nodes.getSize();
        if (size < 0L) {
            log.debug("Using provided estimate total size [ {} ] as actual size [ {} ] could not be retrieved.", properties.get("estimatedTotal", (Object)1000000L), (Object)size);
            size = (Long)properties.get("estimatedTotal", (Object)1000000L);
        }
        int batchSize = (Integer)properties.get("batchSize", (Object)10);
        Bucket bucket = new Bucket(batchSize, size, resource.getChild("batches").getPath(), "sling:Folder");
        String relPath = (String)params.get("relativePath", (Object)"");
        String currentBatch = null;
        int total = 0;
        Node previousBatchNode = null;
        Node batchItemNode = null;
        while (nodes.hasNext()) {
            Node payloadNode = nodes.nextNode();
            log.debug("nodes has next: {}", (Object)nodes.hasNext());
            log.trace("Processing search result [ {} ]", (Object)payloadNode.getPath());
            if (StringUtils.isNotBlank((String)relPath)) {
                if (payloadNode.hasNode(relPath)) {
                    payloadNode = payloadNode.getNode(relPath);
                } else {
                    log.warn("Could not find node at [ {} ]", (Object)(payloadNode.getPath() + "/" + relPath));
                    continue;
                }
            }
            ++total;
            String batchPath = bucket.getNextPath(resourceResolver);
            if (currentBatch == null) {
                currentBatch = batchPath;
            }
            String batchItemPath = batchPath + "/" + total;
            batchItemNode = JcrUtil.createPath((String)batchItemPath, (String)"sling:Folder", (String)"nt:unstructured", (Session)session, (boolean)false);
            log.trace("Created batch item path at [ {} ]", (Object)batchItemPath);
            JcrUtil.setProperty((Node)batchItemNode, (String)"path", (Object)payloadNode.getPath());
            log.trace("Added payload [ {} ] for batch item [ {} ]", (Object)payloadNode.getPath(), (Object)batchItemNode.getPath());
            if (total % batchSize == 0) {
                previousBatchNode = batchItemNode.getParent();
            } else if (total % batchSize == 1 && previousBatchNode != null) {
                JcrUtil.setProperty((Node)previousBatchNode, (String)"nextBatch", (Object)batchItemNode.getParent().getPath());
            }
            if (total % 1000 != 0) continue;
            session.save();
        }
        if (total > 0) {
            JcrUtil.setProperty((Node)batchItemNode.getParent(), (String)"nextBatch", (Object)"complete");
            if (total % 1000 != 0) {
                session.save();
            }
        } else {
            throw new IllegalArgumentException("Query returned zero results.");
        }
        properties.put((Object)"currentBatch", currentBatch);
        properties.put((Object)"total", (Object)total);
        properties.put((Object)"initialized", (Object)true);
        properties.put((Object)"state", (Object)"not started");
        resource.getResourceResolver().commit();
        log.info("Completed initialization of Bulk Workflow Manager");
    }

    @Override
    public final void start(Resource resource) {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        final String jobName = (String)properties.get("jobName", String.class);
        final String workflowModel = (String)properties.get("workflowModel", String.class);
        final String resourcePath = resource.getPath();
        long interval = ((Integer)properties.get("interval", (Object)10)).intValue();
        Runnable job = new Runnable(){
            private Map<String, String> activeWorkflows = new LinkedHashMap<String, String>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block15: {
                    ResourceResolver adminResourceResolver = null;
                    Resource contentResource = null;
                    try {
                        adminResourceResolver = BulkWorkflowEngineImpl.this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                        this.activeWorkflows = BulkWorkflowEngineImpl.this.getActiveWorkflows(adminResourceResolver, this.activeWorkflows);
                        contentResource = adminResourceResolver.getResource(resourcePath);
                        if (contentResource == null) {
                            log.warn("Bulk workflow process resource [ {} ] could not be found. Removing periodic job.", (Object)resourcePath);
                            BulkWorkflowEngineImpl.this.scheduler.removeJob(jobName);
                        } else if (this.activeWorkflows.isEmpty()) {
                            this.activeWorkflows = BulkWorkflowEngineImpl.this.process(contentResource, workflowModel);
                        } else {
                            log.debug("Workflows for batch [ {} ] are still active.", ((ValueMap)contentResource.adaptTo(ValueMap.class)).get("currentBatch", (Object)"Missing batch"));
                            ValueMap properties = (ValueMap)contentResource.adaptTo(ValueMap.class);
                            int batchTimeout = (Integer)properties.get("batchTimeout", (Object)0);
                            Resource currentBatch = BulkWorkflowEngineImpl.this.getCurrentBatch(contentResource);
                            ModifiableValueMap currentBatchProperties = (ModifiableValueMap)currentBatch.adaptTo(ModifiableValueMap.class);
                            int batchTimeoutCount = (Integer)currentBatchProperties.get("batchTimeoutCount", (Object)0);
                            if (batchTimeoutCount >= batchTimeout) {
                                BulkWorkflowEngineImpl.this.terminateActiveWorkflows(adminResourceResolver, contentResource, this.activeWorkflows);
                            } else {
                                currentBatchProperties.put((Object)"batchTimeoutCount", (Object)(batchTimeoutCount + 1));
                                adminResourceResolver.commit();
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Error processing periodic execution: {}", (Object)e.getMessage());
                        try {
                            if (contentResource != null) {
                                BulkWorkflowEngineImpl.this.stop(contentResource, "stopped-error");
                                break block15;
                            }
                            BulkWorkflowEngineImpl.this.scheduler.removeJob(jobName);
                            log.error("Removed scheduled job [ {} ] due to errors content resource [ {} ] could not be found.", (Object)jobName, (Object)resourcePath);
                        }
                        catch (Exception ex) {
                            BulkWorkflowEngineImpl.this.scheduler.removeJob(jobName);
                            log.error("Removed scheduled job [ {} ] due to errors and could not stop normally.", (Object)jobName);
                        }
                    }
                    finally {
                        if (adminResourceResolver != null) {
                            adminResourceResolver.close();
                        }
                    }
                }
            }
        };
        try {
            boolean canRunConcurrently = false;
            this.scheduler.addPeriodicJob(jobName, (Object)job, null, interval, false);
            this.jobs.put(resource.getPath(), jobName);
            log.debug("Added tracking for job [ {} , {} ]", (Object)resource.getPath(), (Object)jobName);
            log.info("Periodic job added for [ {} ] every [ {} seconds ]", (Object)jobName, (Object)interval);
            properties.put((Object)"state", (Object)"running");
            properties.put((Object)"startedAt", (Object)Calendar.getInstance());
            resource.getResourceResolver().commit();
        }
        catch (Exception e) {
            log.error("Error starting bulk workflow management. {}", (Object)e.getMessage());
        }
        log.info("Completed starting of Bulk Workflow Manager");
    }

    @Override
    public final void stop(Resource resource) throws PersistenceException {
        this.stop(resource, "stopped");
    }

    private void stopDeactivate(Resource resource) throws PersistenceException {
        this.stop(resource, "stopped-deactivated");
    }

    private void stop(Resource resource, String state) throws PersistenceException {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        String jobName = (String)properties.get("jobName", String.class);
        log.debug("Stopping job [ {} ]", (Object)jobName);
        if (StringUtils.isNotBlank((String)jobName)) {
            this.scheduler.removeJob(jobName);
            this.jobs.remove(resource.getPath());
            log.info("Bulk Workflow Manager stopped for [ {} ]", (Object)jobName);
            properties.put((Object)"state", (Object)state);
            properties.put((Object)"stoppedAt", (Object)Calendar.getInstance());
            resource.getResourceResolver().commit();
        } else {
            log.error("Trying to stop a job without a name from Bulk Workflow Manager resource [ {} ]", (Object)resource.getPath());
        }
    }

    @Override
    public final void resume(Resource resource) {
        this.start(resource);
        log.info("Resumed bulk workflow for [ {} ]", (Object)resource.getPath());
    }

    @Override
    public final void resume(Resource resource, long interval) throws PersistenceException {
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        properties.put((Object)"interval", (Object)interval);
        resource.getResourceResolver().commit();
        this.start(resource);
        log.info("Resumed bulk workflow for [ {} ] with new interval [ {} ]", (Object)resource.getPath(), (Object)interval);
    }

    private void complete(Resource resource) throws PersistenceException {
        ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        String jobName = (String)mvm.get("jobName", String.class);
        if (StringUtils.isNotBlank((String)jobName)) {
            this.scheduler.removeJob(jobName);
            log.info("Bulk Workflow Manager completed for [ {} ]", (Object)jobName);
            mvm.put((Object)"state", (Object)"complete");
            mvm.put((Object)"completedAt", (Object)Calendar.getInstance());
            resource.getResourceResolver().commit();
        } else {
            log.error("Trying to complete a job without a name from Bulk Workflow Manager resource [ {} ]", (Object)resource.getPath());
        }
    }

    private Map<String, String> process(Resource resource, String workflowModel) throws WorkflowException, PersistenceException, RepositoryException {
        Resource batchToProcess;
        if (log.isDebugEnabled()) {
            log.debug("Processing batch [ {} ] with workflow model [ {} ]", (Object)this.getCurrentBatch(resource).getPath(), (Object)workflowModel);
        }
        Session session = (Session)resource.getResourceResolver().adaptTo(Session.class);
        WorkflowSession workflowSession = this.workflowService.getWorkflowSession(session);
        WorkflowModel model = workflowSession.getModel(workflowModel);
        LinkedHashMap<String, String> workflowMap = new LinkedHashMap<String, String>();
        Resource currentBatch = this.getCurrentBatch(resource);
        ModifiableValueMap currentProperties = (ModifiableValueMap)currentBatch.adaptTo(ModifiableValueMap.class);
        if (currentProperties.get("startedAt", Date.class) == null) {
            currentProperties.put((Object)"startedAt", (Object)Calendar.getInstance());
            batchToProcess = currentBatch;
            log.debug("Virgin batch [ {} ]; preparing to initiate WF.", (Object)currentBatch.getPath());
        } else {
            batchToProcess = this.advance(resource);
            log.debug("Completed batch [ {} ]; preparing to advance and initiate WF on next batch [ {} ].", (Object)currentBatch.getPath(), (Object)batchToProcess);
        }
        if (batchToProcess != null) {
            for (Resource child : batchToProcess.getChildren()) {
                ModifiableValueMap properties = (ModifiableValueMap)child.adaptTo(ModifiableValueMap.class);
                String state = (String)properties.get("state", (Object)"");
                String payloadPath = (String)properties.get("path", String.class);
                if (!StringUtils.isBlank((String)state) || !StringUtils.isNotBlank((String)payloadPath)) continue;
                Workflow workflow = workflowSession.startWorkflow(model, workflowSession.newWorkflowData("JCR_PATH", (Object)payloadPath));
                properties.put((Object)"workflowId", (Object)workflow.getId());
                properties.put((Object)"state", (Object)workflow.getState());
                workflowMap.put(child.getPath(), workflow.getId());
            }
        } else {
            log.error("Cant find the current batch to process.");
        }
        resource.getResourceResolver().commit();
        log.debug("Bulk workflow batch tracking map: {}", workflowMap);
        return workflowMap;
    }

    private Resource advance(Resource resource) throws PersistenceException, RepositoryException {
        ResourceResolver resourceResolver = resource.getResourceResolver();
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        boolean autoCleanupWorkflow = (Boolean)properties.get("purgeWorkflow", (Object)true);
        Resource currentBatch = this.getCurrentBatch(resource);
        ModifiableValueMap currentProperties = (ModifiableValueMap)currentBatch.adaptTo(ModifiableValueMap.class);
        if (autoCleanupWorkflow) {
            this.purge(currentBatch);
        }
        currentProperties.put((Object)"completedAt", (Object)Calendar.getInstance());
        String nextBatchPath = (String)currentProperties.get("nextBatch", (Object)"complete");
        if (StringUtils.equalsIgnoreCase((String)nextBatchPath, (String)"complete")) {
            this.complete(resource);
            properties.put((Object)"complete", (Object)((Integer)properties.get("complete", (Object)0) + this.getSize(currentBatch.getChildren())));
            return null;
        }
        Resource nextBatch = resourceResolver.getResource(nextBatchPath);
        ModifiableValueMap nextProperties = (ModifiableValueMap)nextBatch.adaptTo(ModifiableValueMap.class);
        currentProperties.put((Object)"state", (Object)"complete");
        currentProperties.put((Object)"completedAt", (Object)Calendar.getInstance());
        nextProperties.put((Object)"state", (Object)"running");
        nextProperties.put((Object)"startedAt", (Object)Calendar.getInstance());
        properties.put((Object)"currentBatch", (Object)nextBatch.getPath());
        properties.put((Object)"complete", (Object)((Integer)properties.get("complete", (Object)0) + this.getSize(currentBatch.getChildren())));
        return nextBatch;
    }

    private int purge(Resource batchResource) throws RepositoryException {
        ResourceResolver resourceResolver = batchResource.getResourceResolver();
        ArrayList<String> payloadPaths = new ArrayList<String>();
        for (Resource child : batchResource.getChildren()) {
            ModifiableValueMap properties = (ModifiableValueMap)child.adaptTo(ModifiableValueMap.class);
            String workflowId = (String)properties.get("workflowId", (Object)"Missing WorkflowId");
            String path = (String)properties.get("path", (Object)"Missing Path");
            Resource resource = resourceResolver.getResource(workflowId);
            if (resource != null) {
                Node node = (Node)resource.adaptTo(Node.class);
                node.remove();
                payloadPaths.add(path);
                continue;
            }
            log.warn("Could not find workflowId at [ {} ] to purge.", (Object)workflowId);
        }
        if (payloadPaths.size() > 0) {
            ((Session)resourceResolver.adaptTo(Session.class)).save();
            log.info("Purged {} workflow instances for payloads: {}", (Object)payloadPaths.size(), (Object)Arrays.toString(payloadPaths.toArray(new String[payloadPaths.size()])));
        }
        return payloadPaths.size();
    }

    private Map<String, String> getActiveWorkflows(ResourceResolver resourceResolver, Map<String, String> workflowMap) throws RepositoryException, PersistenceException {
        LinkedHashMap<String, String> activeWorkflowMap = new LinkedHashMap<String, String>();
        WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)resourceResolver.adaptTo(Session.class));
        boolean dirty = false;
        for (Map.Entry<String, String> entry : workflowMap.entrySet()) {
            String workflowId = entry.getValue();
            try {
                Resource resource;
                ModifiableValueMap mvm;
                Workflow workflow = workflowSession.getWorkflow(workflowId);
                if (workflow.isActive()) {
                    activeWorkflowMap.put(entry.getKey(), workflow.getId());
                }
                if (StringUtils.equals((String)((String)(mvm = (ModifiableValueMap)(resource = resourceResolver.getResource(entry.getKey())).adaptTo(ModifiableValueMap.class)).get("state", String.class)), (String)workflow.getState())) continue;
                mvm.put((Object)"state", (Object)workflow.getState());
                dirty = true;
            }
            catch (WorkflowException e) {
                log.error("Could not get workflow with id [ {} ]. {}", (Object)workflowId, (Object)e.getMessage());
            }
        }
        if (dirty) {
            resourceResolver.commit();
        }
        return activeWorkflowMap;
    }

    private int terminateActiveWorkflows(ResourceResolver resourceResolver, Resource contentResource, Map<String, String> workflowMap) throws RepositoryException, PersistenceException {
        WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)resourceResolver.adaptTo(Session.class));
        boolean dirty = false;
        int count = 0;
        for (Map.Entry<String, String> entry : workflowMap.entrySet()) {
            String workflowId = entry.getValue();
            try {
                Workflow workflow = workflowSession.getWorkflow(workflowId);
                if (!workflow.isActive()) continue;
                workflowSession.terminateWorkflow(workflow);
                ++count;
                log.info("Terminated workflow [ {} ]", (Object)workflowId);
                Resource resource = resourceResolver.getResource(entry.getKey());
                ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
                mvm.put((Object)"state", (Object)"force terminated".toUpperCase());
                dirty = true;
            }
            catch (WorkflowException e) {
                log.error("Could not get workflow with id [ {} ]. {}", (Object)workflowId, (Object)e.getMessage());
            }
        }
        if (dirty) {
            ModifiableValueMap properties = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
            properties.put((Object)"forceTerminatedCount", (Object)((Integer)properties.get("forceTerminatedCount", (Object)0) + count));
            resourceResolver.commit();
        }
        return count;
    }

    private int getSize(Iterable<?> theIterable) {
        int count = 0;
        Iterator<?> iterator = theIterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected final void activate(Map<String, String> config) {
        this.jobs = new ConcurrentHashMap();
        ResourceResolver adminResourceResolver = null;
        try {
            adminResourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            String query = "SELECT * FROM [cq:PageContent] WHERE [sling:resourceType] = 'acs-commons/components/utilities/bulk-workflow-manager' AND [state] = 'stopped-deactivated'";
            log.debug("Finding bulk workflows to reactivate using query: {}", (Object)"SELECT * FROM [cq:PageContent] WHERE [sling:resourceType] = 'acs-commons/components/utilities/bulk-workflow-manager' AND [state] = 'stopped-deactivated'");
            Iterator resources = adminResourceResolver.findResources("SELECT * FROM [cq:PageContent] WHERE [sling:resourceType] = 'acs-commons/components/utilities/bulk-workflow-manager' AND [state] = 'stopped-deactivated'", "JCR-SQL2");
            while (resources.hasNext()) {
                Resource resource = (Resource)resources.next();
                log.info("Automatically resuming bulk workflow at [ {} ]", (Object)resource.getPath());
                this.resume(resource);
            }
        }
        catch (LoginException e) {
            log.error("{}", (Object)e.getMessage());
        }
        finally {
            if (adminResourceResolver != null) {
                adminResourceResolver.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected final void deactivate(Map<String, String> config) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            for (Map.Entry<String, String> entry : this.jobs.entrySet()) {
                String path = entry.getKey();
                String jobName = entry.getValue();
                log.debug("Stopping scheduled job at resource [ {} ] and job name [ {} ] by way of de-activation", (Object)path, (Object)jobName);
                try {
                    this.stopDeactivate(resourceResolver.getResource(path));
                }
                catch (Exception e) {
                    this.scheduler.removeJob(jobName);
                    this.jobs.remove(path);
                    log.error("Performed a hard stop for [ {} ] at de-activation due to: ", (Object)jobName, (Object)e.getMessage());
                }
            }
        }
        catch (LoginException e) {
            log.error("Could not acquire a resource resolver: {}", (Object)e.getMessage());
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

