/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.impl.servlets;

import com.adobe.acs.commons.util.TextUtil;
import com.adobe.acs.commons.workflow.bulk.BulkWorkflowEngine;
import com.adobe.acs.commons.workflow.bulk.impl.servlets.HttpErrorUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(label="ACS AEM Commons - Bulk Workflow Manager - Status Servlet", methods={"GET"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"status"}, extensions={"json"})
public class StatusServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(StatusServlet.class);
    private static final int DECIMAL_TO_PERCENT = 100;
    @Reference
    private BulkWorkflowEngine bulkWorkflowEngine;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        ValueMap properties = (ValueMap)request.getResource().adaptTo(ValueMap.class);
        JSONObject json = new JSONObject();
        int total = (Integer)properties.get("total", (Object)0);
        int complete = (Integer)properties.get("complete", (Object)0);
        try {
            json.put("state", properties.get("state", (Object)"not started"));
            json.put("query", properties.get("query", (Object)""));
            json.put("workflowModel", (Object)StringUtils.removeEnd((String)((String)properties.get("workflowModel", (Object)"")), (String)"/jcr:content/model"));
            json.put("batchSize", properties.get("batchSize", (Object)10));
            json.put("currentBatch", properties.get("currentBatch", (Object)"Unknown"));
            json.put("purgeWorkflow", properties.get("purgeWorkflow", (Object)false));
            json.put("interval", properties.get("interval", (Object)10));
            json.put("batchTimeout", properties.get("batchTimeout", (Object)20));
            json.put("total", total);
            json.put("complete", complete);
            json.put("remaining", total - complete);
            json.put("percentComplete", Math.round((float)complete / ((float)total * 1.0f) * 100.0f));
            json.put("forceTerminatedCount", properties.get("forceTerminatedCount", (Object)0));
            json.put("startedAt", properties.get("startedAt", Date.class));
            json.put("stoppedAt", properties.get("stoppedAt", Date.class));
            json.put("completedAt", properties.get("completedAt", Date.class));
            Resource currentBatch = this.bulkWorkflowEngine.getCurrentBatch(request.getResource());
            if (currentBatch != null) {
                json.put("currentBatch", (Object)currentBatch.getPath());
                for (Resource child : currentBatch.getChildren()) {
                    json.accumulate("currentBatchItems", (Object)new JSONObject((Map)child.adaptTo(ValueMap.class)));
                }
                ValueMap currentBatchProperties = (ValueMap)currentBatch.adaptTo(ValueMap.class);
                json.put("batchTimeoutCount", currentBatchProperties.get("batchTimeoutCount", (Object)1));
            }
            response.getWriter().write(json.toString());
        }
        catch (JSONException e) {
            log.error("Could not collect Bulk Workflow status due to: {}", (Object)e.getMessage());
            HttpErrorUtil.sendJSONError(response, 500, "Could not collect Bulk Workflow status.", TextUtil.getFirstNonEmpty(e.getMessage(), "Check to ensure the ACS AEM Commons bundle is installed and active."));
        }
    }

    protected void bindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        this.bulkWorkflowEngine = bulkWorkflowEngine;
    }

    protected void unbindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        if (this.bulkWorkflowEngine == bulkWorkflowEngine) {
            this.bulkWorkflowEngine = null;
        }
    }
}

