/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl;

import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticMetaDataMap;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflow;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.model.WorkflowNode;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.UUID;

public class SyntheticWorkItem
implements WorkItem {
    private static final String CURRENT_ASSIGNEE = "Synthetic Workflow";
    private Date timeStarted = null;
    private Date timeEnded = null;
    private final UUID uuid = UUID.randomUUID();
    private Workflow workflow;
    private WorkflowData workflowData;
    private MetaDataMap metaDataMap = new SyntheticMetaDataMap();

    public SyntheticWorkItem(WorkflowData workflowData) {
        this.workflowData = workflowData;
        this.timeStarted = new Date();
    }

    public final void setWorkflow(SyntheticWorkflow workflow) {
        workflow.setActiveWorkItem(this);
        this.workflow = workflow;
    }

    public final void setTimeEnded(Date timeEnded) {
        this.timeEnded = timeEnded;
    }

    public final String getId() {
        return this.uuid.toString() + "_" + this.getWorkflowData().getPayload();
    }

    public final Date getTimeStarted() {
        return this.timeStarted;
    }

    public final Date getTimeEnded() {
        return this.timeEnded;
    }

    public final WorkflowData getWorkflowData() {
        return this.workflowData;
    }

    public final String getCurrentAssignee() {
        return CURRENT_ASSIGNEE;
    }

    @Deprecated
    public final Dictionary<String, String> getMetaData() {
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        for (String key : this.getMetaDataMap().keySet()) {
            ((Dictionary)dictionary).put(key, (String)this.getMetaDataMap().get(key, String.class));
        }
        return dictionary;
    }

    public final MetaDataMap getMetaDataMap() {
        return this.metaDataMap;
    }

    public final Workflow getWorkflow() {
        return this.workflow;
    }

    public final WorkflowNode getNode() {
        return null;
    }
}

