/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.forms.helpers.impl;

import com.adobe.acs.commons.forms.Form;
import com.adobe.acs.commons.forms.helpers.FormHelper;
import com.adobe.acs.commons.forms.helpers.PostRedirectGetFormHelper;
import com.adobe.acs.commons.forms.helpers.impl.AbstractFormHelperImpl;
import com.adobe.acs.commons.util.TypeUtil;
import com.day.cq.wcm.api.Page;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true)
@Property(label="Service Ranking", name="service.ranking", intValue={500})
@Service(value={FormHelper.class, PostRedirectGetFormHelper.class})
public class PostRedirectGetFormHelperImpl
extends AbstractFormHelperImpl
implements PostRedirectGetFormHelper {
    private static final Logger log = LoggerFactory.getLogger(PostRedirectGetFormHelperImpl.class);

    @Override
    public final Form getForm(String formName, SlingHttpServletRequest request) {
        if (this.doHandlePost(formName, request)) {
            log.debug("Getting FORM [ {} ] from POST parameters", (Object)formName);
            return this.getPostForm(formName, request);
        }
        if (this.doHandleGet(formName, request)) {
            log.debug("Getting FORM [ {} ] from GET parameters", (Object)formName);
            return this.getGetForm(formName, request);
        }
        log.debug("Creating empty form for FORM [ {} ]", (Object)formName);
        return new Form(formName, request.getResource().getPath());
    }

    @Override
    public final void sendRedirect(Form form, String path, SlingHttpServletResponse response) throws IOException, JSONException {
        this.sendRedirect(form, path, null, response);
    }

    @Override
    public final void sendRedirect(Form form, Page page, SlingHttpServletResponse response) throws IOException, JSONException {
        this.sendRedirect(form, page, null, response);
    }

    @Override
    public final void sendRedirect(Form form, Resource resource, SlingHttpServletResponse response) throws IOException, JSONException {
        this.sendRedirect(form, resource, null, response);
    }

    @Override
    public final void sendRedirect(Form form, String path, String formSelector, SlingHttpServletResponse response) throws IOException, JSONException {
        String url = this.getRedirectPath(form, path, formSelector);
        response.sendRedirect(url);
    }

    @Override
    public final void sendRedirect(Form form, Page page, String formSelector, SlingHttpServletResponse response) throws IOException, JSONException {
        String url = this.getRedirectPath(form, page, formSelector);
        response.sendRedirect(url);
    }

    @Override
    public final void sendRedirect(Form form, Resource resource, String formSelector, SlingHttpServletResponse response) throws IOException, JSONException {
        String url = this.getRedirectPath(form, resource, formSelector);
        response.sendRedirect(url);
    }

    @Override
    public final void renderForm(Form form, Page page, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        this.sendRedirect(form, page, this.getFormSelector(request), response);
    }

    @Override
    public final void renderForm(Form form, Resource resource, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        this.sendRedirect(form, resource, this.getFormSelector(request), response);
    }

    @Override
    public final void renderForm(Form form, String path, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        this.sendRedirect(form, path, this.getFormSelector(request), response);
    }

    @Override
    public final void renderOtherForm(Form form, String path, String formSelector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        this.sendRedirect(form, path, formSelector, response);
    }

    @Override
    public final void renderOtherForm(Form form, Page page, String formSelector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        this.sendRedirect(form, page, formSelector, response);
    }

    @Override
    public final void renderOtherForm(Form form, Resource resource, String formSelector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException, JSONException {
        this.sendRedirect(form, resource, formSelector, response);
    }

    protected final boolean doHandle(String formName, SlingHttpServletRequest request) {
        return this.doHandleGet(formName, request) || this.doHandlePost(formName, request);
    }

    protected final boolean doHandleGet(String formName, SlingHttpServletRequest request) {
        if (StringUtils.equalsIgnoreCase((String)"GET", (String)request.getMethod())) {
            return StringUtils.isNotBlank((String)request.getParameter(this.getGetLookupKey(formName)));
        }
        return false;
    }

    protected final Form getGetForm(String formName, SlingHttpServletRequest request) {
        Map<String, String> data = new HashMap<String, String>();
        Map<String, String> errors = new HashMap<String, String>();
        String requestData = this.decode(request.getParameter(this.getGetLookupKey(formName)));
        if (StringUtils.isBlank((String)requestData)) {
            return new Form(formName, request.getResource().getPath());
        }
        try {
            JSONObject jsonData = new JSONObject(requestData);
            String incomingFormName = jsonData.optString("n");
            if (StringUtils.equals((String)incomingFormName, (String)formName)) {
                JSONObject incomingJsonErrors;
                JSONObject incomingJsonForm = jsonData.optJSONObject("f");
                if (incomingJsonForm != null) {
                    data = TypeUtil.toMap(incomingJsonForm, String.class);
                    log.debug("Form data: {}", data);
                }
                if ((incomingJsonErrors = jsonData.optJSONObject("e")) != null) {
                    errors = TypeUtil.toMap(incomingJsonErrors, String.class);
                    log.debug("Form data: {}", errors);
                }
            }
        }
        catch (JSONException e) {
            log.warn("Cannot parse query parameters for request: {}", (Object)requestData);
            return new Form(formName, request.getResource().getPath());
        }
        return new Form(formName, request.getResource().getPath(), this.getProtectedData(data), this.getProtectedErrors(errors));
    }

    protected final String getGetLookupKey(String formName) {
        return "f_" + formName;
    }

    protected final String getRedirectPath(Form form, Page page, String formSelector) throws JSONException, UnsupportedEncodingException {
        return this.getRedirectPath(form, (Resource)page.adaptTo(Resource.class), formSelector);
    }

    protected final String getRedirectPath(Form form, Resource resource, String formSelector) throws JSONException, UnsupportedEncodingException {
        return this.getRedirectPath(form, resource.getPath() + ".html", formSelector);
    }

    protected final String getRedirectPath(Form form, String path, String formSelector) throws JSONException {
        String redirectPath = path;
        redirectPath = redirectPath + this.getSuffix();
        if (StringUtils.isNotBlank((String)formSelector)) {
            redirectPath = redirectPath + "/" + formSelector;
        }
        redirectPath = redirectPath + "?";
        redirectPath = redirectPath + this.getQueryParameters(form);
        return redirectPath;
    }

    protected final String getQueryParameters(Form form) throws JSONException {
        boolean hasData = false;
        JSONObject jsonData = new JSONObject();
        String params = "";
        form = this.clean(form);
        jsonData.put("n", (Object)form.getName());
        if (form.hasData()) {
            JSONObject jsonForm = new JSONObject(form.getData());
            jsonData.put("f", (Object)jsonForm);
            hasData = true;
        }
        if (form.hasErrors()) {
            JSONObject jsonError = new JSONObject(form.getErrors());
            jsonData.put("e", (Object)jsonError);
            hasData = true;
        }
        if (hasData) {
            params = this.getGetLookupKey(form.getName());
            params = params + "=";
            params = params + this.encode(jsonData.toString());
        }
        return params;
    }
}

