/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.day.image.Layer;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Property(name="type", value={"crop"})
@Service
public class CropImageTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(CropImageTransformerImpl.class);
    static final String TYPE = "crop";
    private static final String KEY_BOUNDS = "bounds";
    private static final String KEY_SMART_BOUNDING = "smart";
    private static final int NUM_BOUNDS_PARAMS = 4;
    private static final int PARAM_INDEX_X = 0;
    private static final int PARAM_INDEX_Y = 1;
    private static final int PARAM_INDEX_WIDTH = 2;
    private static final int PARAM_INDEX_HEIGHT = 3;

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)TYPE);
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)TYPE);
        boolean smartBounding = (Boolean)properties.get(KEY_SMART_BOUNDING, (Object)true);
        String[] bounds = StringUtils.split((String)((String)properties.get(KEY_BOUNDS, (Object)"")), (String)",");
        if (bounds.length == 4) {
            int x = Integer.parseInt(bounds[0]);
            int y = Integer.parseInt(bounds[1]);
            int width = Integer.parseInt(bounds[2]);
            int height = Integer.parseInt(bounds[3]);
            Rectangle rectangle = new Rectangle();
            if (smartBounding) {
                rectangle = this.getSmartBounds(x, y, width, height, layer.getWidth(), layer.getHeight());
            } else {
                rectangle.setBounds(x, y, width, height);
            }
            layer.crop((Rectangle2D)rectangle);
            if (smartBounding && layer.getWidth() != width || layer.getHeight() != height) {
                log.debug("SmartBounding resulted in an image of an incorrect size (based on crop params). resizing to: [ width: {}, height: {} ]", (Object)width, (Object)height);
                layer.resize(width, height);
            }
        }
        return layer;
    }

    private Rectangle getSmartBounds(int x, int y, int width, int height, int layerWidth, int layerHeight) {
        Rectangle rectangle = new Rectangle();
        int x2 = x + width;
        int y2 = y + height;
        if (x2 >= layerWidth && y2 >= layerHeight) {
            float clipPercentX = (float)(x2 - layerWidth) / (float)width;
            float clipPercentY = (float)(y2 - layerHeight) / (float)height;
            if (clipPercentX >= clipPercentY) {
                return this.constrainByWidth(x, y, width, height, layerWidth, x2);
            }
            return this.constrainByHeight(x, y, width, height, layerHeight, y2);
        }
        if (x2 >= layerWidth && y2 < layerHeight) {
            return this.constrainByWidth(x, y, width, height, layerWidth, x2);
        }
        if (x2 < layerWidth && y2 >= layerHeight) {
            return this.constrainByHeight(x, y, width, height, layerHeight, y2);
        }
        rectangle.setBounds(x, y, width, height);
        return rectangle;
    }

    private Rectangle constrainByHeight(int x, int y, int width, int height, int layerHeight, int y2) {
        Rectangle rectangle = new Rectangle();
        int deltaY = y2 - layerHeight;
        int deltaX = Math.round((float)deltaY / (float)height * (float)width);
        rectangle.setBounds(x, y, width - deltaX, height - deltaY);
        return rectangle;
    }

    private Rectangle constrainByWidth(int x, int y, int width, int height, int layerWidth, int x2) {
        Rectangle rectangle = new Rectangle();
        int deltaX = x2 - layerWidth;
        int deltaY = Math.round((float)deltaX / (float)width * (float)height);
        rectangle.setBounds(x, y, width - deltaX, height - deltaY);
        return rectangle;
    }
}

