/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.json;

import java.util.Iterator;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;

public abstract class AbstractJSONObjectVisitor {
    public void accept(JSONObject jsonObject) {
        if (jsonObject != null) {
            this.visit(jsonObject);
            this.traverseJSONObject(jsonObject);
        }
    }

    public void accept(JSONArray jsonArray) {
        if (jsonArray != null) {
            this.traverseJSONArray(jsonArray);
        }
    }

    protected final void traverseJSONObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (jsonObject.optJSONObject(key) != null) {
                this.accept(jsonObject.optJSONObject(key));
                continue;
            }
            if (jsonObject.optJSONArray(key) == null) continue;
            this.accept(jsonObject.optJSONArray(key));
        }
    }

    protected final void traverseJSONArray(JSONArray jsonArray) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (jsonArray.optJSONObject(i) != null) {
                this.accept(jsonArray.optJSONObject(i));
                continue;
            }
            if (jsonArray.optJSONArray(i) == null) continue;
            this.accept(jsonArray.optJSONArray(i));
        }
    }

    protected abstract void visit(JSONObject var1);
}

