/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.logging.impl;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.net.SyslogAppenderBase;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, label="ACS AEM Commons - Syslog Appender", description="Logback appender to send messages using Syslog")
public final class SyslogAppender {
    private static final String ROOT = "ROOT";
    private static final int DEFAULT_PORT = -1;
    private static final String DEFAULT_SUFFIX_PATTERN = "[%thread] %-5level %logger{36} - %msg%n";
    private static final String DEFAULT_FACILITY = "USER";
    private static final boolean DEFAULT_THROWABLE_EXCLUDED = false;
    @Property(label="Host", description="Host of Syslog server")
    private static final String PROP_HOST = "host";
    @Property(label="Logger Names", description="List of logger categories (ROOT for all)", unbounded=PropertyUnbounded.ARRAY, value={"ROOT"})
    private static final String PROP_LOGGERS = "loggers";
    @Property(label="Port", description="Port of Syslog server", intValue={-1})
    private static final String PROP_PORT = "port";
    @Property(label="Suffix Pattern", description="Logback Pattern defining the message format.", value={"[%thread] %-5level %logger{36} - %msg%n"})
    private static final String PROP_SUFFIX_PATTERN = "suffix.pattern";
    @Property(label="Syslog Facility", value={"USER"}, propertyPrivate=true, description="The Syslog Facility is meant to identify the source of a message, separately from any context included in the Suffix Pattern. The facility option must be set to one of the strings KERN, USER, MAIL, DAEMON, AUTH, SYSLOG, LPR, NEWS, UUCP, CRON, AUTHPRIV, FTP, NTP, AUDIT, ALERT, CLOCK, LOCAL0, LOCAL1, LOCAL2, LOCAL3, LOCAL4, LOCAL5, LOCAL6, LOCAL7. Case is not important.")
    private static final String PROP_FACILITY = "facility";
    @Property(label="Stack Trace Pattern", description="Logback Pattern for customizing the string appearing just before each stack trace line. The default value for this property is a single tab character.")
    private static final String PROP_STACK_TRACE_PATTERN = "stack.trace.pattern";
    @Property(label="Exclude Throwables", description="Set to true to cause stack trace data associated with a Throwable to be omitted. By default, this is set to false so that stack trace data is sent to the syslog server.", boolValue={false})
    private static final String PROP_THROWABLE_EXCLUDED = "throwable.excluded";
    private ch.qos.logback.classic.net.SyslogAppender appender;
    private ServiceRegistration appenderRegistration;

    @Activate
    protected void activate(ComponentContext ctx) {
        Dictionary properties = ctx.getProperties();
        String[] loggers = PropertiesUtil.toStringArray(properties.get(PROP_LOGGERS), (String[])new String[]{ROOT});
        String suffixPattern = PropertiesUtil.toString(properties.get(PROP_SUFFIX_PATTERN), (String)DEFAULT_SUFFIX_PATTERN);
        int port = PropertiesUtil.toInteger(properties.get(PROP_PORT), (int)-1);
        String host = PropertiesUtil.toString(properties.get(PROP_HOST), null);
        String facility = PropertiesUtil.toString(properties.get(PROP_FACILITY), (String)DEFAULT_FACILITY);
        String stackTracePattern = PropertiesUtil.toString(properties.get(PROP_STACK_TRACE_PATTERN), null);
        boolean throwableExcluded = PropertiesUtil.toBoolean(properties.get(PROP_THROWABLE_EXCLUDED), (boolean)false);
        if (host == null || port == -1) {
            throw new IllegalArgumentException("Syslog Appender not configured correctly. Both host and port need to be provided.");
        }
        SyslogAppenderBase.facilityStringToint((String)facility);
        BundleContext bundleContext = ctx.getBundleContext();
        this.appender = new ch.qos.logback.classic.net.SyslogAppender();
        this.appender.setSyslogHost(host);
        this.appender.setPort(port);
        this.appender.setFacility(facility);
        this.appender.setSuffixPattern(suffixPattern);
        if (StringUtils.isNotEmpty((String)stackTracePattern)) {
            this.appender.setStackTracePattern(stackTracePattern);
        }
        this.appender.setThrowableExcluded(throwableExcluded);
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put(PROP_LOGGERS, loggers);
        this.appenderRegistration = bundleContext.registerService(Appender.class.getName(), (Object)this.appender, props);
    }

    @Deactivate
    protected void deactivate() {
        if (this.appender != null) {
            this.appender.stop();
            this.appender = null;
        }
        if (this.appenderRegistration != null) {
            this.appenderRegistration.unregister();
            this.appenderRegistration = null;
        }
    }
}

