/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import aQute.bnd.annotation.ProviderType;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class ParameterUtil {
    private static final Logger log = LoggerFactory.getLogger(ParameterUtil.class);

    private ParameterUtil() {
    }

    public static AbstractMap.SimpleEntry<String, String> toSimpleEntry(String value, String separator) {
        String[] tmp = StringUtils.split((String)value, (String)separator);
        if (tmp == null) {
            return null;
        }
        if (tmp.length == 2) {
            return new AbstractMap.SimpleEntry<String, String>(tmp[0], tmp[1]);
        }
        return null;
    }

    public static Map<String, String> toMap(String[] values, String separator) {
        return ParameterUtil.toMap(values, separator, false, null);
    }

    public static Map<String, String> toMap(String[] values, String separator, boolean allowValuelessKeys, String defaultValue) {
        return ParameterUtil.toMap(values, separator, allowValuelessKeys, defaultValue, false);
    }

    public static Map<String, String> toMap(String[] values, String separator, boolean allowValuelessKeys, String defaultValue, boolean allowMultipleSeparators) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (values == null || values.length < 1) {
            return map;
        }
        for (String value : values) {
            String[] tmp = StringUtils.split((String)value, (String)separator, (int)(allowMultipleSeparators ? 2 : -1));
            if (tmp.length == 1 && allowValuelessKeys) {
                if (StringUtils.startsWith((String)value, (String)separator)) continue;
                map.put(tmp[0], defaultValue);
                continue;
            }
            if (tmp.length != 2) continue;
            map.put(tmp[0], tmp[1]);
        }
        return map;
    }

    public static Map<String, String[]> toMap(String[] values, String mapSeparator, String listSeparator) {
        Map<String, String> map = ParameterUtil.toMap(values, mapSeparator);
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(entry.getKey(), StringUtils.split((String)entry.getValue(), (String)listSeparator));
        }
        return result;
    }
}

