/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import java.util.Arrays;
import java.util.Map;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="ACS AEM Commons - OSGI Component Disabler", description="Disables components by configuration", policy=ConfigurationPolicy.REQUIRE)
@Service
@Property(name="event.topics", value={"org/osgi/framework/BundleEvent/STARTED", "org/osgi/framework/ServiceEvent/REGISTERED"}, propertyPrivate=true)
public class ComponentDisabler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(ComponentDisabler.class);
    @Reference
    private ScrService scrService;
    @Property(label="Disabled components", description="The names of the components/services you want to disable", cardinality=0x7FFFFFFF)
    private static final String DISABLED_COMPONENTS = "components";
    private String[] disabledComponents;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.disabledComponents = PropertiesUtil.toStringArray((Object)properties.get(DISABLED_COMPONENTS), (String[])new String[0]);
        this.handleEvent(null);
    }

    public void handleEvent(Event event) {
        log.trace("Disabling components and services {}", (Object)Arrays.toString(this.disabledComponents));
        for (String component : this.disabledComponents) {
            this.disableComponent(component);
        }
    }

    private boolean disableComponent(String componentName) {
        org.apache.felix.scr.Component[] comps = this.scrService.getComponents(componentName);
        if (comps != null) {
            for (org.apache.felix.scr.Component comp : comps) {
                if (comp.getState() == 1) continue;
                log.info("Component {} disabled by configuration (pid={}) ", new Object[]{comp.getClassName(), comp.getConfigurationPid()});
                comp.disable();
            }
        }
        return true;
    }

    protected void bindScrService(ScrService scrService) {
        this.scrService = scrService;
    }

    protected void unbindScrService(ScrService scrService) {
        if (this.scrService == scrService) {
            this.scrService = null;
        }
    }
}

