/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.jcr.resource.JcrResourceUtil;

public final class EvolutionConfig {
    private String[] ignoreProperties;
    private String[] ignoreResources;

    public EvolutionConfig(String[] ignoreProperties, String[] ignoreResources) {
        this.ignoreProperties = ignoreProperties;
        this.ignoreResources = ignoreResources;
    }

    public int getDepthForPath(String path) {
        return StringUtils.countMatches((String)StringUtils.substringAfterLast((String)path, (String)"jcr:frozenNode"), (String)"/");
    }

    public String getRelativePropertyName(String path) {
        return StringUtils.substringAfterLast((String)path, (String)"jcr:frozenNode").replaceFirst("/", "");
    }

    public String getRelativeResourceName(String path) {
        return StringUtils.substringAfterLast((String)path, (String)"jcr:frozenNode/");
    }

    public boolean handleProperty(String name) {
        for (String entry : this.ignoreProperties) {
            if (!Pattern.matches(entry, name)) continue;
            return false;
        }
        return true;
    }

    public boolean handleResource(String name) {
        for (String entry : this.ignoreResources) {
            if (!Pattern.matches(entry, name)) continue;
            return false;
        }
        return true;
    }

    public String printProperty(Property property) {
        try {
            return this.printObject(JcrResourceUtil.toJavaObject((Property)property));
        }
        catch (RepositoryException e1) {
            return e1.getMessage();
        }
    }

    public String printObject(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            String result = "[";
            for (int i = 0; i < values.length; ++i) {
                result = result + values[i];
                if (i == values.length - 1) continue;
                result = result + ", ";
            }
            result = result + "]";
            return result;
        }
        if (obj instanceof Calendar) {
            Calendar value = (Calendar)obj;
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateFormat.format(value.getTime());
        }
        return obj.toString();
    }
}

