/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import com.adobe.acs.commons.version.Evolution;
import com.adobe.acs.commons.version.EvolutionContext;
import com.adobe.acs.commons.version.impl.EvolutionConfig;
import com.adobe.acs.commons.version.impl.EvolutionImpl;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvolutionContextImpl
implements EvolutionContext {
    private static final Logger log = LoggerFactory.getLogger(EvolutionContext.class);
    private Resource resource = null;
    private VersionHistory history = null;
    private ResourceResolver resolver = null;
    private VersionManager versionManager = null;
    private List<Evolution> versions = new ArrayList<Evolution>();
    private EvolutionConfig config;

    public EvolutionContextImpl(Resource resource, EvolutionConfig config) {
        this.resource = resource.isResourceType("cq:Page") ? resource.getChild("jcr:content") : resource;
        this.config = config;
        this.populateEvolutions();
    }

    @Override
    public List<Evolution> getEvolutionItems() {
        return this.versions;
    }

    private void populateEvolutions() {
        try {
            this.resolver = this.resource.getResourceResolver();
            this.versionManager = ((Session)this.resolver.adaptTo(Session.class)).getWorkspace().getVersionManager();
            this.history = this.versionManager.getVersionHistory(this.resource.getPath());
            VersionIterator iter = this.history.getAllVersions();
            while (iter.hasNext()) {
                Version next = (Version)iter.next();
                String versionPath = next.getFrozenNode().getPath();
                Resource versionResource = this.resolver.resolve(versionPath);
                this.versions.add(new EvolutionImpl(next, versionResource, this.config));
                log.debug("Version={} added to EvolutionItem", (Object)next.getName());
            }
        }
        catch (UnsupportedRepositoryOperationException e1) {
            log.warn("Could not find version for resource={}", (Object)this.resource.getPath());
        }
        catch (Exception e) {
            log.error("Could not find versions", (Throwable)e);
        }
    }
}

