/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import com.adobe.acs.commons.version.EvolutionEntry;
import com.adobe.acs.commons.version.impl.EvolutionConfig;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvolutionEntryImpl
implements EvolutionEntry {
    private static final Logger log = LoggerFactory.getLogger(EvolutionEntryImpl.class);
    private static int MAX_CHARS = 200;
    private static String V_ADDED = "added";
    private static String V_CHANGED = "changed";
    private static String V_REMOVED = "removed";
    private EvolutionEntry.EvolutionEntryType type;
    private String name;
    private Object value;
    private int depth;
    private String path;
    private Version version;
    private String relativePath;
    private Property property;
    private EvolutionConfig config;

    public EvolutionEntryImpl(Resource resource, Version version, EvolutionConfig config) {
        this.config = config;
        this.type = EvolutionEntry.EvolutionEntryType.RESOURCE;
        this.name = resource.getName();
        this.depth = config.getDepthForPath(resource.getPath());
        this.path = resource.getParent().getName();
        this.version = version;
        this.value = null;
        this.relativePath = config.getRelativeResourceName(resource.getPath());
    }

    public EvolutionEntryImpl(Property property, Version version, EvolutionConfig config) {
        try {
            this.config = config;
            this.property = property;
            this.type = EvolutionEntry.EvolutionEntryType.PROPERTY;
            this.name = property.getName();
            this.depth = config.getDepthForPath(property.getPath());
            this.version = version;
            this.path = property.getParent().getName();
            this.value = config.printProperty(property);
            this.relativePath = config.getRelativePropertyName(property.getPath());
        }
        catch (Exception e) {
            log.error("Could not inititalize VersionEntry", (Throwable)e);
        }
    }

    @Override
    public boolean isResource() {
        return EvolutionEntry.EvolutionEntryType.RESOURCE == this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueName() {
        return (this.name + this.path).replace(":", "_").replace("/", "_").replace("@", "_");
    }

    @Override
    public EvolutionEntry.EvolutionEntryType getType() {
        return this.type;
    }

    @Override
    public String getValueString() {
        return this.config.printObject(this.value);
    }

    @Override
    public String getValueStringShort() {
        String value = this.getValueString();
        if (value.length() > MAX_CHARS) {
            return value.substring(0, MAX_CHARS) + "...";
        }
        return value;
    }

    @Override
    public int getDepth() {
        return this.depth - 1;
    }

    @Override
    public boolean isCurrent() {
        try {
            Version[] successors = this.version.getSuccessors();
            if (successors == null || successors.length == 0) {
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getStatus() {
        if (this.isAdded()) {
            return V_ADDED;
        }
        if (this.isWillBeRemoved()) {
            return V_REMOVED;
        }
        if (this.isChanged()) {
            return V_CHANGED;
        }
        return "";
    }

    @Override
    public boolean isAdded() {
        try {
            if (this.isResource()) {
                Node node = this.version.getLinearPredecessor().getFrozenNode().getNode(this.relativePath);
                return node == null;
            }
            Property prop = this.version.getLinearPredecessor().getFrozenNode().getProperty(this.relativePath);
            return prop == null;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public boolean isWillBeRemoved() {
        try {
            if (this.isCurrent()) {
                return false;
            }
            if (this.isResource()) {
                Node node = this.version.getLinearPredecessor().getFrozenNode().getNode(this.relativePath);
                return node == null;
            }
            Property prop = this.version.getLinearSuccessor().getFrozenNode().getProperty(this.relativePath);
            return prop == null;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public boolean isChanged() {
        try {
            String oldValue;
            if (this.isResource()) {
                return false;
            }
            Property prop = this.version.getLinearPredecessor().getFrozenNode().getProperty(this.relativePath);
            String currentValue = this.config.printProperty(prop);
            return !currentValue.equals(oldValue = this.config.printProperty(this.property));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

