/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.json.AbstractJSONObjectVisitor;
import com.adobe.acs.commons.util.BufferingResponse;
import com.adobe.acs.commons.util.PathInfoUtil;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(selectors={"overlay.cqinclude.namespace"}, extensions={"json"}, resourceTypes={"sling/servlet/default"})
public final class CQIncludePropertyNamespaceServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(CQIncludePropertyNamespaceServlet.class);
    private static final String REQ_ATTR = CQIncludePropertyNamespaceServlet.class.getName() + ".processed";
    private static final String AEM_CQ_INCLUDE_SELECTORS = "overlay.infinity";
    private static final int NAME_PROPERTY_SELECTOR_INDEX = 3;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        if (!this.accepts(request)) {
            response.setStatus(404);
            response.getWriter().write(new JSONObject().toString());
        }
        RequestUtil.setRequestAttribute((HttpServletRequest)request, (String)REQ_ATTR, (Object)true);
        String prefix = URLDecoder.decode(PathInfoUtil.getSelector(request, 3), "UTF-8");
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSelectors(AEM_CQ_INCLUDE_SELECTORS);
        BufferingResponse bufferingResponse = new BufferingResponse((HttpServletResponse)response);
        request.getRequestDispatcher(request.getResource(), options).forward((ServletRequest)request, (ServletResponse)bufferingResponse);
        try {
            JSONObject json = new JSONObject(bufferingResponse.getContents());
            NamePropertyUpdater namePropertyUpdater = new NamePropertyUpdater(prefix);
            namePropertyUpdater.accept(json);
            response.getWriter().write(json.toString());
        }
        catch (JSONException e) {
            log.error("Error composing the cqinclude JSON representation of the widget overlay for [ {} ]", (Object)request.getRequestURI(), (Object)e);
            response.setStatus(500);
            response.getWriter().write(new JSONObject().toString());
        }
    }

    private boolean accepts(SlingHttpServletRequest request) {
        if (request.getAttribute(REQ_ATTR) != null) {
            log.warn("Identified a cyclic loop in the ACS Commons CQ Include Namespace prefix Servlet for [ {} ]", (Object)request.getRequestURI());
            return false;
        }
        for (int i = 0; i <= 3; ++i) {
            if (!StringUtils.isBlank((String)PathInfoUtil.getSelector(request, i))) continue;
            return false;
        }
        return true;
    }

    private class NamePropertyUpdater
    extends AbstractJSONObjectVisitor {
        private final Logger log = LoggerFactory.getLogger(NamePropertyUpdater.class);
        private static final String PN_NAME = "name";
        private static final String NT_CQ_WIDGET = "cq:Widget";
        private final String namespace;

        public NamePropertyUpdater(String namespace) {
            this.namespace = namespace;
        }

        @Override
        protected void visit(JSONObject jsonObject) {
            if (StringUtils.equals((String)jsonObject.optString("jcr:primaryType"), (String)NT_CQ_WIDGET)) {
                String nameValue = jsonObject.optString(PN_NAME);
                if (StringUtils.isNotBlank((String)(nameValue = StringUtils.removeStart((String)nameValue, (String)"./")))) {
                    try {
                        jsonObject.put(PN_NAME, (Object)("./" + this.namespace + "/" + nameValue));
                    }
                    catch (JSONException e) {
                        this.log.error("Error updating the Name property of the JSON object", (Throwable)e);
                    }
                }
            }
        }
    }
}

