/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.granite.xss.XSSAPI;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;

@SlingServlet(paths={"/bin/acs-commons/custom-importers"})
public final class CustomPollingImporterListServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -4921197948987912363L;
    private transient ServiceTracker tracker;

    @Activate
    protected void activate(ComponentContext ctx) throws InvalidSyntaxException {
        BundleContext bundleContext = ctx.getBundleContext();
        StringBuilder builder = new StringBuilder();
        builder.append("(&(");
        builder.append("objectClass").append("=").append("com.day.cq.polling.importer.Importer").append(")");
        builder.append("(displayName=*))");
        Filter filter = bundleContext.createFilter(builder.toString());
        this.tracker = new ServiceTracker(bundleContext, filter, null);
        this.tracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this.tracker.close();
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        XSSAPI xssAPI = (XSSAPI)request.adaptTo(XSSAPI.class);
        try {
            JSONObject result = new JSONObject();
            JSONArray list = new JSONArray();
            result.put("list", (Object)list);
            ServiceReference[] services = this.tracker.getServiceReferences();
            if (services != null) {
                for (ServiceReference service : services) {
                    String displayName = PropertiesUtil.toString((Object)service.getProperty("displayName"), null);
                    String[] schemes = PropertiesUtil.toStringArray((Object)service.getProperty("importer.scheme"));
                    if (displayName == null || schemes == null) continue;
                    for (String scheme : schemes) {
                        JSONObject obj = new JSONObject();
                        obj.put("qtip", (Object)"");
                        obj.put("text", (Object)displayName);
                        obj.put("text_xss", (Object)xssAPI.encodeForJSString(displayName));
                        obj.put("value", (Object)scheme);
                        list.put((Object)obj);
                    }
                }
            }
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            result.write((Writer)response.getWriter());
        }
        catch (JSONException e) {
            throw new ServletException("Unable to generate importer list", (Throwable)e);
        }
    }
}

