/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class PropertyMergePostProcessor
implements SlingPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(PropertyMergePostProcessor.class);
    private static final String AT_SUFFIX = "@PropertyMerge";
    private static final String ALLOW_DUPLICATES_SUFFIX = "@PropertyMerge.AllowDuplicates";
    private static final String TYPE_HINT_SUFFIX = "@PropertyMerge.TypeHint";
    private static final String IGNORE_PREFIX = ":";

    public final void process(SlingHttpServletRequest request, List<Modification> modifications) throws Exception {
        List<PropertyMerge> propertyMerges = this.getPropertyMerges(request.getRequestParameterMap());
        Resource resource = request.getResource();
        for (PropertyMerge propertyMerge : propertyMerges) {
            if (!this.merge(resource, propertyMerge.getDestination(), propertyMerge.getSources(), propertyMerge.getTypeHint(), propertyMerge.isAllowDuplicates())) continue;
            modifications.add(Modification.onModified((String)resource.getPath()));
            log.debug("Merged property values from {} into [ {} ]", propertyMerge.getSources(), (Object)propertyMerge.getDestination());
        }
    }

    private List<PropertyMerge> getPropertyMerges(RequestParameterMap requestParameterMap) {
        HashMap<String, ArrayList<String>> mapping = new HashMap<String, ArrayList<String>>();
        for (Map.Entry entry : requestParameterMap.entrySet()) {
            if (!StringUtils.endsWith((String)((String)entry.getKey()), (String)AT_SUFFIX)) continue;
            String source = StringUtils.removeStart((String)StringUtils.substringBefore((String)((String)entry.getKey()), (String)AT_SUFFIX), (String)IGNORE_PREFIX);
            for (RequestParameter requestParameter : (RequestParameter[])entry.getValue()) {
                String destination;
                if (requestParameter == null || (destination = StringUtils.removeStart((String)StringUtils.stripToNull((String)requestParameter.getString()), (String)IGNORE_PREFIX)) == null) continue;
                ArrayList<String> sources = (ArrayList<String>)mapping.get(destination);
                if (sources == null) {
                    sources = new ArrayList<String>();
                }
                sources.add(source);
                mapping.put(StringUtils.strip((String)requestParameter.getString()), sources);
            }
        }
        ArrayList<PropertyMerge> propertyMerges = new ArrayList<PropertyMerge>();
        for (Map.Entry entry : mapping.entrySet()) {
            String destination = (String)entry.getKey();
            List sources = (List)entry.getValue();
            RequestParameter allowDuplicatesParam = requestParameterMap.getValue(IGNORE_PREFIX + destination + ALLOW_DUPLICATES_SUFFIX);
            boolean allowDuplicates = allowDuplicatesParam != null ? Boolean.valueOf(allowDuplicatesParam.getString()) : false;
            RequestParameter typeHintParam = requestParameterMap.getValue(IGNORE_PREFIX + destination + TYPE_HINT_SUFFIX);
            String typeHint = typeHintParam != null ? typeHintParam.getString() : String.class.getSimpleName();
            propertyMerges.add(new PropertyMerge(destination, sources, allowDuplicates, typeHint));
        }
        return propertyMerges;
    }

    protected final <T> boolean merge(Resource resource, String destination, List<String> sources, Class<T> typeHint, boolean allowDuplicates) throws PersistenceException {
        Object[] emptyArray = (Object[])Array.newInstance(typeHint, 0);
        ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        AbstractCollection collectedValues = null;
        collectedValues = allowDuplicates ? new ArrayList() : new LinkedHashSet();
        for (String source : sources) {
            Object[] tmp = (Object[])properties.get(source, (Object)emptyArray);
            if (tmp == null) continue;
            collectedValues.addAll(Arrays.asList(tmp));
        }
        Object[] currentValues = (Object[])properties.get(destination, (Object)emptyArray);
        if (!collectedValues.equals(Arrays.asList(currentValues))) {
            properties.put((Object)destination, (Object)collectedValues.toArray(emptyArray));
            return true;
        }
        return false;
    }

    private class PropertyMerge {
        private boolean allowDuplicates;
        private Class<?> typeHint;
        private String destination;
        private List<String> sources;

        public PropertyMerge(String destination, List<String> sources, boolean allowDuplicates, String typeHint) {
            this.destination = destination;
            this.sources = sources;
            this.allowDuplicates = allowDuplicates;
            this.typeHint = this.convertTypeHint(typeHint);
        }

        private Class<?> convertTypeHint(String typeHintStr) {
            if (Boolean.class.getSimpleName().equalsIgnoreCase(typeHintStr)) {
                return Boolean.class;
            }
            if (Double.class.getSimpleName().equalsIgnoreCase(typeHintStr)) {
                return Double.class;
            }
            if (Long.class.getSimpleName().equalsIgnoreCase(typeHintStr)) {
                return Long.class;
            }
            if (Date.class.getSimpleName().equalsIgnoreCase(typeHintStr) || Calendar.class.getSimpleName().equalsIgnoreCase(typeHintStr)) {
                return Calendar.class;
            }
            return String.class;
        }

        public boolean isAllowDuplicates() {
            return this.allowDuplicates;
        }

        public Class<?> getTypeHint() {
            return this.typeHint;
        }

        public String getDestination() {
            return this.destination;
        }

        public List<String> getSources() {
            return this.sources;
        }
    }
}

