/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.impl;

import com.day.cq.commons.jcr.JcrUtil;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Bucket {
    private static final Logger log = LoggerFactory.getLogger(Bucket.class);
    private static final int MAX_DEPTH = 100000;
    private static final String NT_SLING_FOLDER = "sling:Folder";
    private final int bucketSize;
    private final long total;
    private final String bucketType;
    private int[] depthTracker;
    private int bucketCount = 0;
    private String rootPath;

    public Bucket(int bucketSize, long total) {
        this(bucketSize, total, NT_SLING_FOLDER, "/content/" + String.valueOf(System.currentTimeMillis()));
    }

    public Bucket(int bucketSize, long total, String rootPath, String bucketType) {
        this.bucketSize = bucketSize;
        this.total = (long)this.bucketSize > total ? (long)this.bucketSize : total;
        this.bucketType = bucketType;
        this.rootPath = rootPath;
        this.initDepthTracker();
    }

    public String getNextPath(ResourceResolver resourceResolver) throws RepositoryException {
        this.updateDepthTracker();
        if (this.needsNewBucket()) {
            this.bucketCount = 0;
        }
        String path = this.getOrCreateBucketPath(resourceResolver);
        ++this.bucketCount;
        return path;
    }

    private boolean needsNewBucket() {
        return this.bucketCount >= this.bucketSize;
    }

    private String getOrCreateBucketPath(ResourceResolver resourceResolver) throws RepositoryException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        StringBuilder sb = new StringBuilder(this.rootPath);
        for (int i = 0; i < this.depthTracker.length; ++i) {
            String tmp = Integer.toString(this.depthTracker[i] + 1);
            sb.append("/").append(tmp);
        }
        String folderPath = sb.toString();
        if (resourceResolver.getResource(folderPath) != null) {
            return folderPath;
        }
        Node node = JcrUtil.createPath((String)folderPath, (String)this.bucketType, (String)this.bucketType, (Session)session, (boolean)false);
        log.debug("Created new folder path at [ {} ]", (Object)node.getPath());
        return node.getPath();
    }

    private void initDepthTracker() {
        int depth = this.getDepth();
        this.depthTracker = new int[depth];
        Arrays.fill(this.depthTracker, 0);
    }

    private void updateDepthTracker() {
        if (!this.needsNewBucket()) {
            return;
        }
        for (int i = this.depthTracker.length - 1; i >= 0; --i) {
            if (this.depthTracker[i] < this.bucketSize - 1) {
                this.depthTracker[i] = this.depthTracker[i] + 1;
                log.debug("Updating depthTracker: {}", (Object)Arrays.toString(this.depthTracker));
                break;
            }
            this.depthTracker[i] = 0;
        }
    }

    private int getDepth() {
        int depth = 0;
        long remainingSize = this.total;
        if (this.bucketSize < 2) {
            throw new IllegalStateException("Trying to build bucket structure with bucket size [ " + this.bucketSize + "]. Refusing as this does not make sense, and is a flat list of nodes.");
        }
        do {
            remainingSize = (long)Math.ceil((double)remainingSize / (double)this.bucketSize);
            log.debug("Remaining size of [ {} ] at depth [ {} ]", (Object)remainingSize, (Object)depth);
        } while (remainingSize > (long)this.bucketSize && ++depth < 100000);
        if (depth == 100000) {
            throw new IllegalStateException("Bucket Max Depth of {} reached. Cowardly refusing to support such a large bucket structure");
        }
        log.debug("Final depth of [ {} ]", (Object)depth);
        return depth;
    }
}

