/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.impl.servlets;

import com.adobe.acs.commons.workflow.bulk.impl.servlets.HttpErrorUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import java.io.IOException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"GET"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"init-form"}, extensions={"json"})
public class InitFormServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(InitFormServlet.class);
    @Reference
    private WorkflowService workflowService;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JSONObject json = new JSONObject();
        WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)request.getResourceResolver().adaptTo(Session.class));
        try {
            WorkflowModel[] workflowModels;
            for (WorkflowModel workflowModel : workflowModels = workflowSession.getModels()) {
                JSONObject jsonWorkflow = new JSONObject();
                try {
                    jsonWorkflow.put("label", (Object)workflowModel.getTitle());
                    jsonWorkflow.put("value", (Object)workflowModel.getId());
                    json.accumulate("workflowModels", (Object)jsonWorkflow);
                }
                catch (JSONException e) {
                    log.error("Could not add workflow [ {} - {} ] to Workflow Models dropdown JSON object", (Object)workflowModel.getTitle(), (Object)workflowModel.getId());
                }
            }
            response.getWriter().write(json.toString());
        }
        catch (WorkflowException e) {
            log.error("Could not create workflow model drop-down due to: {}", (Throwable)e);
            HttpErrorUtil.sendJSONError(response, 500, "Could not collect Workflows", e.getMessage());
        }
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }
}

