/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.impl.servlets;

import com.adobe.acs.commons.workflow.bulk.BulkWorkflowEngine;
import com.adobe.acs.commons.workflow.bulk.impl.servlets.HttpErrorUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"start"}, extensions={"json"})
public class StartServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(StartServlet.class);
    @Reference
    private BulkWorkflowEngine bulkWorkflowEngine;

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            ValueMapDecorator map = new ValueMapDecorator(new HashMap());
            map.put((Object)"query", (Object)params.getString("query"));
            map.put((Object)"relativePath", (Object)StringUtils.removeStart((String)params.optString("relativePath", ""), (String)"/"));
            map.put((Object)"workflowModel", (Object)params.getString("workflowModel"));
            map.put((Object)"batchSize", (Object)params.optInt("batchSize", 10));
            map.put((Object)"interval", (Object)params.optInt("interval", 10));
            map.put((Object)"batchTimeout", (Object)params.optInt("batchTimeout", 20));
            map.put((Object)"estimatedTotal", (Object)params.optLong("estimatedTotal", 1000000L));
            map.put((Object)"purgeWorkflow", (Object)params.optBoolean("purgeWorkflow", false));
            this.bulkWorkflowEngine.initialize(request.getResource(), (ValueMap)map);
            this.bulkWorkflowEngine.start(request.getResource());
            response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, request.getResource().getPath()) + ".status.json");
        }
        catch (JSONException e) {
            log.error("Could not parse HTTP Request params: {}", (Throwable)e);
            HttpErrorUtil.sendJSONError(response, 500, "Could not initialize Bulk Workflow due to invalid parameters. Please review the form and try again.", e.getMessage());
        }
        catch (RepositoryException e) {
            log.error("Could not initialize Bulk Workflow: {}", (Throwable)e);
            HttpErrorUtil.sendJSONError(response, 500, "Could not initialize Bulk Workflow.", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.warn("Could not initialize Bulk Workflow due to invalid arguments: {}", (Throwable)e);
            HttpErrorUtil.sendJSONError(response, 500, "Could not initialize Bulk Workflow due to invalid arguments.", e.getMessage());
        }
        catch (Exception e) {
            log.error("Could not initialize Bulk Workflow due to unexpected error: {}", (Throwable)e);
            HttpErrorUtil.sendJSONError(response, 500, "Could not start Bulk Workflow.", e.getMessage());
        }
    }

    protected void bindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        this.bulkWorkflowEngine = bulkWorkflowEngine;
    }

    protected void unbindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        if (this.bulkWorkflowEngine == bulkWorkflowEngine) {
            this.bulkWorkflowEngine = null;
        }
    }
}

