/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal.impl;

import com.adobe.acs.commons.workflow.bulk.removal.WorkflowInstanceRemover;
import com.adobe.acs.commons.workflow.bulk.removal.impl.WorkflowInstanceFolderComparator;
import com.adobe.acs.commons.workflow.bulk.removal.impl.WorkflowRemovalException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public final class WorkflowInstanceRemoverImpl
implements WorkflowInstanceRemover {
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceRemoverImpl.class);
    private static final SimpleDateFormat WORKFLOW_FOLDER_FORMAT = new SimpleDateFormat("YYYY-MM-dd");
    private static final String PN_PAYLOAD_PATH = "data/payload/path";
    private static final String NT_SLING_FOLDER = "sling:Folder";
    private static final String NT_CQ_WORKFLOW = "cq:Workflow";
    private static final Pattern NN_SERVER_FOLDER_PATTERN = Pattern.compile("server\\d+");
    private static final Pattern NN_DATE_FOLDER_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}.*");
    private static final int BATCH_SIZE = 1000;
    private static final int MAX_SAVE_RETRIES = 5;

    @Override
    public int removeWorkflowInstances(ResourceResolver resourceResolver, Collection<String> modelIds, Collection<String> statuses, Collection<Pattern> payloads, Calendar olderThan) throws PersistenceException, WorkflowRemovalException, InterruptedException {
        return this.removeWorkflowInstances(resourceResolver, modelIds, statuses, payloads, olderThan, 1000);
    }

    @Override
    public int removeWorkflowInstances(ResourceResolver resourceResolver, Collection<String> modelIds, Collection<String> statuses, Collection<Pattern> payloads, Calendar olderThan, int batchSize) throws PersistenceException, WorkflowRemovalException, InterruptedException {
        try {
            long start = System.currentTimeMillis();
            this.start(resourceResolver);
            int count = 0;
            int checkedCount = 0;
            int workflowRemovedCount = 0;
            List<Resource> containerFolders = this.getWorkflowInstanceFolders(resourceResolver);
            for (Resource containerFolder : containerFolders) {
                log.debug("Checking [ {} ] for workflow instances to remove", (Object)containerFolder.getPath());
                Collection<Resource> sortedFolders = this.getSortedAndFilteredFolders(containerFolder);
                for (Resource folder : sortedFolders) {
                    int remaining = 0;
                    for (Resource instance : folder.getChildren()) {
                        ValueMap properties = instance.getValueMap();
                        if (!StringUtils.equals((String)NT_CQ_WORKFLOW, (String)((String)properties.get("jcr:primaryType", String.class)))) {
                            ++remaining;
                            continue;
                        }
                        ++checkedCount;
                        String status = (String)properties.get("status", String.class);
                        String model = (String)properties.get("modelId", String.class);
                        Calendar startTime = (Calendar)properties.get("startedAt", Calendar.class);
                        String payload = (String)properties.get(PN_PAYLOAD_PATH, String.class);
                        if (CollectionUtils.isNotEmpty(statuses) && !statuses.contains(status)) {
                            log.trace("Workflow instance [ {} ] has non-matching status of [ {} ]", (Object)instance.getPath(), (Object)status);
                            ++remaining;
                            continue;
                        }
                        if (CollectionUtils.isNotEmpty(modelIds) && !modelIds.contains(model)) {
                            log.trace("Workflow instance [ {} ] has non-matching model of [ {} ]", (Object)instance.getPath(), (Object)model);
                            ++remaining;
                            continue;
                        }
                        if (olderThan != null && startTime != null && startTime.before(olderThan)) {
                            log.trace("Workflow instance [ {} ] has non-matching start time of [ {} ]", (Object)instance.getPath(), (Object)startTime);
                            ++remaining;
                            continue;
                        }
                        if (CollectionUtils.isNotEmpty(payloads)) {
                            boolean match = false;
                            if (StringUtils.isNotEmpty((String)payload)) {
                                for (Pattern pattern : payloads) {
                                    if (!payload.matches(pattern.pattern())) continue;
                                    match = true;
                                    break;
                                }
                                if (!match) {
                                    log.trace("Workflow instance [ {} ] has non-matching payload path [ {} ]", (Object)instance.getPath(), (Object)payload);
                                    ++remaining;
                                    continue;
                                }
                            }
                        }
                        try {
                            ((Node)instance.adaptTo(Node.class)).remove();
                            log.debug("Removed workflow instance at [ {} ]", (Object)instance.getPath());
                            ++workflowRemovedCount;
                            ++count;
                        }
                        catch (RepositoryException e) {
                            log.error("Could not remove workflow instance at [ {} ]. Continuing...", (Object)instance.getPath(), (Object)e);
                        }
                        if (count % batchSize != 0) continue;
                        this.batchComplete(resourceResolver, checkedCount, workflowRemovedCount);
                        log.info("Removed a running total of [ {} ] workflow instances", (Object)count);
                    }
                    if (remaining != 0 || !NN_DATE_FOLDER_PATTERN.matcher(folder.getName()).matches() || StringUtils.startsWith((String)folder.getName(), (String)WORKFLOW_FOLDER_FORMAT.format(new Date()))) continue;
                    try {
                        ((Node)folder.adaptTo(Node.class)).remove();
                        log.debug("Removed empty workflow folder node [ {} ]", (Object)folder.getPath());
                        ++count;
                    }
                    catch (RepositoryException e) {
                        log.error("Could not remove workflow folder at [ {} ]", (Object)folder.getPath(), (Object)e);
                    }
                }
                this.complete(resourceResolver, checkedCount, workflowRemovedCount);
            }
            log.info("Removed a total of [ {} ] workflow instances in [ {} ] ms", (Object)count, (Object)(System.currentTimeMillis() - start));
            return count;
        }
        catch (PersistenceException e) {
            log.error("Error persisting changes with Workflow Removal", (Throwable)e);
            this.error(resourceResolver);
            throw e;
        }
        catch (WorkflowRemovalException e) {
            log.error("Error with Workflow Removal", (Throwable)e);
            this.error(resourceResolver);
            throw e;
        }
        catch (InterruptedException e) {
            log.error("Errors in persistence retries during Workflow Removal", (Throwable)e);
            this.error(resourceResolver);
            throw e;
        }
    }

    private Collection<Resource> getSortedAndFilteredFolders(Resource folderResource) {
        TreeSet<Resource> sortedCollection = new TreeSet<Resource>(new WorkflowInstanceFolderComparator());
        Iterator folders = folderResource.listChildren();
        while (folders.hasNext()) {
            Resource folder = (Resource)folders.next();
            if (!folder.isResourceType(NT_SLING_FOLDER)) continue;
            sortedCollection.add(folder);
        }
        return sortedCollection;
    }

    private void save(ResourceResolver resourceResolver) throws PersistenceException, InterruptedException {
        int count = 0;
        while (count++ <= 5) {
            try {
                if (resourceResolver.hasChanges()) {
                    long start = System.currentTimeMillis();
                    resourceResolver.commit();
                    log.debug("Saving batch workflow instance removal in [ {} ] ms", (Object)(System.currentTimeMillis() - start));
                }
                return;
            }
            catch (PersistenceException ex) {
                if (count <= 5) {
                    resourceResolver.refresh();
                    log.warn("Could not persist Workflow Removal changes, trying again in {} ms", (Object)(1000 * count));
                    Thread.sleep(1000 * count);
                    continue;
                }
                throw ex;
            }
        }
    }

    private void start(ResourceResolver resourceResolver) throws PersistenceException, WorkflowRemovalException, InterruptedException {
        Resource resource = resourceResolver.getResource("/etc/acs-commons/workflow-remover/jcr:content/status");
        ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (StringUtils.equals((String)WorkflowInstanceRemover.Status.RUNNING.toString(), (String)((String)mvm.get("status", String.class)))) {
            throw new WorkflowRemovalException("Workflow removal already started by " + mvm.put((Object)"initiatedBy", (Object)"Unknown"));
        }
        mvm.put((Object)"initiatedBy", (Object)resourceResolver.getUserID());
        mvm.put((Object)"status", (Object)StringUtils.lowerCase((String)WorkflowInstanceRemover.Status.RUNNING.toString()));
        mvm.put((Object)"startedAt", (Object)System.currentTimeMillis());
        mvm.put((Object)"count", (Object)0);
        mvm.put((Object)"checkedCount", (Object)0);
        mvm.remove((Object)"completedAt");
        this.save(resourceResolver);
    }

    private void batchComplete(ResourceResolver resourceResolver, int checked, int count) throws PersistenceException, InterruptedException {
        Resource resource = resourceResolver.getResource("/etc/acs-commons/workflow-remover/jcr:content/status");
        ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        mvm.put((Object)"status", (Object)StringUtils.lowerCase((String)WorkflowInstanceRemover.Status.RUNNING.toString()));
        mvm.put((Object)"checkedCount", (Object)checked);
        mvm.put((Object)"count", (Object)count);
        this.save(resourceResolver);
    }

    private void complete(ResourceResolver resourceResolver, int checked, int count) throws PersistenceException, InterruptedException {
        Resource resource = resourceResolver.getResource("/etc/acs-commons/workflow-remover/jcr:content/status");
        ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        mvm.put((Object)"status", (Object)StringUtils.lowerCase((String)WorkflowInstanceRemover.Status.COMPLETE.toString()));
        mvm.put((Object)"checkedCount", (Object)checked);
        mvm.put((Object)"count", (Object)count);
        mvm.put((Object)"completedAt", (Object)System.currentTimeMillis());
        this.save(resourceResolver);
    }

    private void error(ResourceResolver resourceResolver) throws PersistenceException, InterruptedException {
        resourceResolver.revert();
        Resource resource = resourceResolver.getResource("/etc/acs-commons/workflow-remover/jcr:content/status");
        ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        mvm.put((Object)"status", (Object)StringUtils.lowerCase((String)WorkflowInstanceRemover.Status.ERROR.toString()));
        mvm.put((Object)"checkedCount", (Object)-1);
        mvm.put((Object)"count", (Object)-1);
        mvm.put((Object)"completedAt", (Object)System.currentTimeMillis());
        this.save(resourceResolver);
    }

    private List<Resource> getWorkflowInstanceFolders(ResourceResolver resourceResolver) {
        ArrayList<Resource> folders = new ArrayList<Resource>();
        Resource root = resourceResolver.getResource("/etc/workflow/instances");
        Iterator itr = root.listChildren();
        boolean addedRoot = false;
        while (itr.hasNext()) {
            Resource resource = (Resource)itr.next();
            if (NN_SERVER_FOLDER_PATTERN.matcher(resource.getName()).matches()) {
                folders.add(resource);
                continue;
            }
            if (addedRoot || !NN_DATE_FOLDER_PATTERN.matcher(resource.getName()).matches()) continue;
            folders.add(root);
            addedRoot = true;
        }
        if (folders.isEmpty()) {
            folders.add(root);
        }
        return folders;
    }
}

