/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.xss;

import aQute.bnd.annotation.ProviderType;
import com.adobe.granite.xss.XSSAPI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ProviderType
public final class XSSFunctions {
    private static final String LINK_PREFIX = "<a href='";
    private static final String LINK_SUFFIX = "'></a>";
    private static final String MANGLE_NAMESPACE_IN_PREFIX = "/_";
    private static final String MANGLE_NAMESPACE_IN_SUFFIX = "_";
    private static final String MANGLE_NAMESPACE_OUT = "/([^:/]+):";
    private static final String MANGLE_NAMESPACE_OUT_SUFFIX = ":";
    private static final Pattern MANGLE_NAMESPACE_PATTERN = Pattern.compile("/([^:/]+):");

    public static CharSequence encodeForHTML(XSSAPI xssAPI, String source) {
        return xssAPI.encodeForHTML(source);
    }

    public static CharSequence encodeForHTMLAttr(XSSAPI xssAPI, String source) {
        return xssAPI.encodeForHTMLAttr(source);
    }

    public static CharSequence encodeForJSString(XSSAPI xssAPI, String source) {
        return xssAPI.encodeForJSString(source);
    }

    public static CharSequence filterHTML(XSSAPI xssAPI, String source) {
        return xssAPI.filterHTML(source);
    }

    public static CharSequence getValidHref(XSSAPI xssAPI, String source) {
        try {
            String testHtml = LINK_PREFIX + XSSFunctions.mangleNamespaces(source) + LINK_SUFFIX;
            String safeHtml = xssAPI.filterHTML(testHtml);
            return safeHtml.substring(LINK_PREFIX.length(), safeHtml.length() - LINK_SUFFIX.length());
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String mangleNamespaces(String absPath) {
        if (absPath != null && absPath.contains(MANGLE_NAMESPACE_OUT_SUFFIX)) {
            Matcher m = MANGLE_NAMESPACE_PATTERN.matcher(absPath);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String replacement = MANGLE_NAMESPACE_IN_PREFIX + m.group(1) + MANGLE_NAMESPACE_IN_SUFFIX;
                m.appendReplacement(buf, replacement);
            }
            m.appendTail(buf);
            absPath = buf.toString();
        }
        return absPath;
    }

    private XSSFunctions() {
    }

    public static String getValidDimension(XSSAPI xssAPI, String dimension, String defaultValue) {
        return xssAPI.getValidDimension(dimension, defaultValue);
    }

    public static Integer getValidInteger(XSSAPI xssAPI, String integer, int defaultValue) {
        return xssAPI.getValidInteger(integer, defaultValue);
    }

    public static String getValidJSToken(XSSAPI xssAPI, String token, String defaultValue) {
        return xssAPI.getValidJSToken(token, defaultValue);
    }
}

