/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.analysis.jcrchecksum.impl;

import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGenerator;
import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGeneratorOptions;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.DefaultChecksumGeneratorOptions;
import com.day.jcr.vault.util.Text;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class ChecksumGeneratorImpl
implements ChecksumGenerator {
    private static final Logger log = LoggerFactory.getLogger(ChecksumGeneratorImpl.class);

    @Override
    public Map<String, String> generateChecksums(Session session, String path) throws RepositoryException, IOException {
        return this.generateChecksums(session, path, new DefaultChecksumGeneratorOptions());
    }

    @Override
    public Map<String, String> generateChecksums(Session session, String path, ChecksumGeneratorOptions options) throws RepositoryException, IOException {
        Node node = session.getNode(path);
        if (node == null) {
            log.warn("Path [ {} ] not found while generating checksums", (Object)path);
            return new LinkedHashMap<String, String>();
        }
        return this.traverseTree(node, options);
    }

    private Map<String, String> traverseTree(Node node, ChecksumGeneratorOptions options) throws RepositoryException, IOException {
        LinkedHashMap<String, String> checksums = new LinkedHashMap<String, String>();
        if (this.isChecksumable(node, options)) {
            checksums.put(node.getPath(), this.generatedNodeChecksum(node.getPath(), node, options));
            log.debug("Top Level Node: {} ~> {}", (Object)node.getPath(), checksums.get(node.getPath()));
        } else {
            NodeIterator children = node.getNodes();
            while (children.hasNext()) {
                checksums.putAll(this.traverseTree(children.nextNode(), options));
            }
        }
        return checksums;
    }

    private boolean isChecksumable(Node node, ChecksumGeneratorOptions options) throws RepositoryException {
        Set<String> nodeTypeIncludes = options.getIncludedNodeTypes();
        Set<String> nodeTypeExcludes = options.getExcludedNodeTypes();
        String primaryNodeType = node.getPrimaryNodeType().getName();
        return nodeTypeIncludes.contains(primaryNodeType) && !nodeTypeExcludes.contains(primaryNodeType);
    }

    protected String generatedNodeChecksum(String aggregateNodePath, Node node, ChecksumGeneratorOptions options) throws RepositoryException, IOException {
        Set<String> nodeTypeExcludes = options.getExcludedNodeTypes();
        LinkedHashMap<String, String> checksums = new LinkedHashMap<String, String>();
        checksums.put(this.getChecksumKey(aggregateNodePath, node.getPath()), this.generatePropertyChecksums(aggregateNodePath, node, options));
        TreeMap<String, String> lexicographicallySortedChecksums = new TreeMap<String, String>();
        boolean hasOrderedChildren = this.hasOrderedChildren(node);
        NodeIterator children = node.getNodes();
        while (children.hasNext()) {
            Node child = children.nextNode();
            if (nodeTypeExcludes.contains(child.getPrimaryNodeType().getName())) continue;
            if (hasOrderedChildren) {
                checksums.put(this.getChecksumKey(aggregateNodePath, child.getPath()), this.generatedNodeChecksum(aggregateNodePath, child, options));
                log.debug("Aggregated Ordered Node: {} ~> {}", (Object)this.getChecksumKey(aggregateNodePath, child.getPath()), checksums.get(this.getChecksumKey(aggregateNodePath, child.getPath())));
                continue;
            }
            lexicographicallySortedChecksums.put(this.getChecksumKey(aggregateNodePath, child.getPath()), this.generatedNodeChecksum(aggregateNodePath, child, options));
            log.debug("Aggregated Unordered Node: {} ~> {}", (Object)this.getChecksumKey(aggregateNodePath, child.getPath()), lexicographicallySortedChecksums.get(this.getChecksumKey(aggregateNodePath, child.getPath())));
        }
        if (!hasOrderedChildren && lexicographicallySortedChecksums.size() > 0) {
            checksums.putAll(lexicographicallySortedChecksums);
        }
        String nodeChecksum = this.aggregateChecksums(checksums);
        log.debug("Node [ {} ] has a aggregated checksum of [ {} ]", (Object)this.getChecksumKey(aggregateNodePath, node.getPath()), (Object)nodeChecksum);
        return nodeChecksum;
    }

    protected String generatePropertyChecksums(String aggregateNodePath, Node node, ChecksumGeneratorOptions options) throws RepositoryException, IOException {
        TreeMap<String, String> propertyChecksums = new TreeMap<String, String>();
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            if (options.getExcludedProperties().contains(property.getName())) {
                log.debug("Excluding property: {}", (Object)(node.getPath() + "/@" + property.getName()));
                continue;
            }
            ArrayList<String> checksums = new ArrayList<String>();
            List<Value> values = this.getPropertyValues(property);
            for (Value value : values) {
                if (value.getType() == 2) {
                    checksums.add(this.getBinaryChecksum(value));
                    continue;
                }
                checksums.add(ChecksumGeneratorImpl.getStringChecksum(value));
            }
            if (!options.getSortedProperties().contains(property.getName())) {
                Collections.sort(checksums);
            }
            if (log.isDebugEnabled()) {
                log.debug("Property: {} ~> {}", (Object)this.getChecksumKey(aggregateNodePath, property.getPath()), (Object)StringUtils.join(checksums, (String)","));
            }
            propertyChecksums.put(this.getChecksumKey(aggregateNodePath, property.getPath()), StringUtils.join(checksums, (String)","));
        }
        return this.aggregateChecksums(propertyChecksums);
    }

    protected String getChecksumKey(String aggregatePath, String path) {
        if ("/".equals(aggregatePath) && "/".equals(path)) {
            return "/";
        }
        if ("/".equals(aggregatePath)) {
            return path;
        }
        String baseNodeName = Text.getName((String)aggregatePath);
        String relPath = StringUtils.removeStart((String)path, (String)aggregatePath);
        return baseNodeName + relPath;
    }

    private List<Value> getPropertyValues(Property property) throws RepositoryException {
        ArrayList<Value> values = new ArrayList<Value>();
        if (property.isMultiple()) {
            values.addAll(Arrays.asList(property.getValues()));
        } else {
            values.add(property.getValue());
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBinaryChecksum(Value value) throws RepositoryException, IOException {
        InputStream stream = null;
        try {
            stream = value.getBinary().getStream();
            String string = DigestUtils.shaHex((InputStream)stream);
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected static String getStringChecksum(Value value) throws RepositoryException {
        return DigestUtils.shaHex((String)value.getString());
    }

    protected boolean hasOrderedChildren(Node node) throws RepositoryException {
        boolean hasOrderedChildren = false;
        try {
            hasOrderedChildren = node.getPrimaryNodeType().hasOrderableChildNodes();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return hasOrderedChildren;
    }

    protected String aggregateChecksums(Map<String, String> checksums) {
        StringBuilder data = new StringBuilder();
        for (Map.Entry<String, String> entry : checksums.entrySet()) {
            data.append(entry.getKey() + "=" + entry.getValue());
        }
        return DigestUtils.shaHex((String)data.toString());
    }
}

