/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.analysis.jcrchecksum.impl.options;

import aQute.bnd.annotation.ProviderType;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.AbstractChecksumGeneratorOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class RequestChecksumGeneratorOptions
extends AbstractChecksumGeneratorOptions {
    private static final Logger log = LoggerFactory.getLogger(RequestChecksumGeneratorOptions.class);

    public RequestChecksumGeneratorOptions(SlingHttpServletRequest request) throws IOException {
        this.addIncludedNodeTypes(request.getParameterValues("nodeTypes"));
        this.addExcludedNodeTypes(request.getParameterValues("excludeNodeTypes"));
        this.addExcludedProperties(request.getParameterValues("excludeProperties"));
        this.addSortedProperties(request.getParameterValues("sortedProperties"));
    }

    public static Set<String> getPaths(SlingHttpServletRequest request) throws IOException {
        HashSet<String> paths = new HashSet<String>();
        if (request.getParameterValues("paths") != null) {
            String[] pathArr;
            for (String path : pathArr = request.getParameterValues("paths")) {
                if (path.length() <= 0) continue;
                paths.add(path);
            }
        }
        paths.addAll(RequestChecksumGeneratorOptions.getPathsFromQuery(request.getResourceResolver(), request.getParameter("queryType"), request.getParameter("query")));
        RequestParameter data = request.getRequestParameter("data");
        if (data != null && data.getInputStream() != null) {
            paths.addAll(RequestChecksumGeneratorOptions.getPathsFromInputstream(data.getInputStream(), request.getCharacterEncoding()));
        }
        return paths;
    }

    private static Set<String> getPathsFromQuery(ResourceResolver resourceResolver, String language, String query) {
        if (StringUtils.isBlank((String)query)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> paths = new HashSet<String>();
        language = StringUtils.defaultIfEmpty((String)language, (String)"xpath");
        Iterator resources = resourceResolver.findResources(query, language);
        while (resources.hasNext()) {
            paths.add(((Resource)resources.next()).getPath());
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getPathsFromInputstream(InputStream is, String encoding) throws IOException {
        if (is == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> paths = new HashSet<String>();
        encoding = encoding != null ? encoding : Charset.defaultCharset().name();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        try {
            String path;
            while ((path = br.readLine()) != null) {
                paths.add(path);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return paths;
    }

    private static List<String> asList(String[] arr) {
        if (arr == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(arr);
    }
}

