/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.impl;

import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(label="Event Topics", value={"com/adobe/granite/taskmanagement/event"}, description="[Required] Event Topics this event handler will to respond to.", name="event.topics", propertyPrivate=true), @Property(label="Event Filters", value={"(&(TaskTypeName=dam:review)(EventType=TASK_COMPLETED))"}, description="[Optional] Event Filters used to further restrict this event handler; Uses LDAP expression against event properties.", name="event.filter", propertyPrivate=true)})
@Service
public class ReviewTaskAssetMoverHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(ReviewTaskAssetMoverHandler.class);
    private static final String PATH_CONTENT_DAM = "/content/dam";
    private static final String APPROVED = "approved";
    private static final String REJECTED = "rejected";
    private static final String REL_PN_DAM_STATUS = "jcr:content/metadata/dam:status";
    private static final String PN_DAM_STATUS = "dam:status";
    private static final String PN_ON_APPROVE = "onApproveMoveTo";
    private static final String PN_ON_REJECT = "onRejectMoveTo";
    private static final String PN_CONTENT_PATH = "contentPath";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    @Reference
    private QueryBuilder queryBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        ResourceResolver resourceResolver = null;
        try {
            ValueMap taskProperties;
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            String path = (String)event.getProperty("TaskId");
            Resource taskResource = resourceResolver.getResource(path);
            if (taskResource != null && (StringUtils.startsWith((String)((String)(taskProperties = taskResource.getValueMap()).get(PN_ON_APPROVE, String.class)), (String)PATH_CONTENT_DAM) || StringUtils.startsWith((String)((String)taskProperties.get(PN_ON_REJECT, String.class)), (String)PATH_CONTENT_DAM))) {
                log.debug("Handling event (creating a Job) for Assets Review Task @ [ {} ]", (Object)path);
                ScheduleOptions options = this.scheduler.NOW();
                String jobName = this.getClass().getSimpleName().toString().replace(".", "/") + "/" + path;
                options.name(jobName);
                options.canRunConcurrently(false);
                this.scheduler.schedule((Object)new ImmediateJob(path), options);
            }
        }
        catch (LoginException e) {
            log.error("Could not get resource resolver", (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    private class ImmediateJob
    implements Runnable {
        private final String path;

        public ImmediateJob(String path) {
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("Processing Review Task Asset Move for [ {} ]", (Object)this.path);
            ResourceResolver resourceResolver = null;
            try {
                ValueMap taskProperties;
                String contentPath;
                resourceResolver = ReviewTaskAssetMoverHandler.this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource resource = resourceResolver.getResource(this.path);
                AssetManager assetManager = (AssetManager)resourceResolver.adaptTo(AssetManager.class);
                if (resource != null && StringUtils.startsWith((String)(contentPath = (String)(taskProperties = resource.getValueMap()).get(ReviewTaskAssetMoverHandler.PN_CONTENT_PATH, String.class)), (String)ReviewTaskAssetMoverHandler.PATH_CONTENT_DAM)) {
                    Iterator<Resource> assets = this.findAssets(resourceResolver, contentPath);
                    while (assets.hasNext()) {
                        Asset asset = (Asset)assets.next().adaptTo(Asset.class);
                        log.debug("Processing asset [ {} ]", (Object)asset.getPath());
                        this.moveAsset(assetManager, asset, taskProperties);
                    }
                    if (resourceResolver.hasChanges()) {
                        resourceResolver.commit();
                    }
                }
            }
            catch (LoginException e) {
                log.error("Could not get resource resolver", (Throwable)e);
            }
            catch (PersistenceException e) {
                log.error("Could not persist changes", (Throwable)e);
            }
            finally {
                if (resourceResolver != null) {
                    resourceResolver.close();
                }
            }
        }

        private Iterator<Resource> findAssets(ResourceResolver resourceResolver, String contentPath) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("type", "dam:Asset");
            params.put("path", contentPath);
            params.put("property", ReviewTaskAssetMoverHandler.REL_PN_DAM_STATUS);
            params.put("property.1_value", ReviewTaskAssetMoverHandler.APPROVED);
            params.put("property.2_value", ReviewTaskAssetMoverHandler.REJECTED);
            params.put("limit", "-1");
            Query query = ReviewTaskAssetMoverHandler.this.queryBuilder.createQuery(PredicateGroup.create(params), (Session)resourceResolver.adaptTo(Session.class));
            return query.getResult().getResources();
        }

        private void moveAsset(AssetManager assetManager, Asset asset, ValueMap taskProperties) {
            String status = asset.getMetadataValue(ReviewTaskAssetMoverHandler.PN_DAM_STATUS);
            String onApprovePath = (String)taskProperties.get(ReviewTaskAssetMoverHandler.PN_ON_APPROVE, String.class);
            String onRejectPath = (String)taskProperties.get(ReviewTaskAssetMoverHandler.PN_ON_REJECT, String.class);
            String destPath = null;
            if (StringUtils.equals((String)ReviewTaskAssetMoverHandler.APPROVED, (String)status)) {
                destPath = onApprovePath;
            } else if (StringUtils.equals((String)ReviewTaskAssetMoverHandler.REJECTED, (String)status)) {
                destPath = onRejectPath;
            }
            if (destPath != null) {
                if (StringUtils.startsWith((String)destPath, (String)ReviewTaskAssetMoverHandler.PATH_CONTENT_DAM)) {
                    assetManager.moveAsset(asset.getPath(), destPath + "/" + asset.getName());
                    log.info("Moved [ {} ] ~> [ {} ] based on approval status [ " + status + " ]", (Object)asset.getPath(), (Object)(destPath + "/" + asset.getName()));
                } else {
                    log.warn("Request to move reviewed asset to a non DAM Asset path [ {} ]", (Object)destPath);
                }
            }
        }
    }
}

