/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam;

import aQute.bnd.annotation.ProviderType;
import com.adobe.acs.commons.functions.BiConsumer;
import com.adobe.acs.commons.functions.BiFunction;
import com.adobe.acs.commons.functions.Consumer;
import com.adobe.acs.commons.functions.Function;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowRunner;
import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.AssetManager;
import com.adobe.granite.asset.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import java.util.Iterator;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

@Component(metatype=true, immediate=true, label="Deferred Actions")
@Service(value={DeferredActions.class})
@ProviderType
public final class DeferredActions {
    @Reference
    private SyntheticWorkflowRunner workflowRunner;
    @Reference
    private Replicator replicator;
    public Function<Boolean, Boolean> not = new Function<Boolean, Boolean>(){

        @Override
        public Boolean apply(Boolean t) {
            return t == false;
        }
    };

    public BiFunction<ResourceResolver, String, Boolean> filterMatching(final String glob) {
        return new BiFunction<ResourceResolver, String, Boolean>(){

            @Override
            public Boolean apply(ResourceResolver r, String path) {
                return path.matches(glob);
            }
        };
    }

    public BiFunction<ResourceResolver, String, Boolean> filterNotMatching(String glob) {
        return this.filterMatching(glob).andThen(this.not);
    }

    public BiFunction<ResourceResolver, String, Boolean> filterOutSubassets() {
        return this.filterNotMatching(".*?/subassets/.*");
    }

    public BiFunction<ResourceResolver, String, Boolean> filterNonAssets() {
        return new BiFunction<ResourceResolver, String, Boolean>(){

            @Override
            public Boolean apply(ResourceResolver r, String path) {
                DeferredActions.this.nameThread("filterNonAssets-" + path);
                Resource res = r.getResource(path);
                return DamUtil.resolveToAsset((Resource)res) != null;
            }
        };
    }

    public BiConsumer<ResourceResolver, String> retryAll(final int retries, final long pausePerRetry, final BiConsumer<ResourceResolver, String> action) {
        return new BiConsumer<ResourceResolver, String>(){

            @Override
            public void accept(ResourceResolver r, String s) throws Exception {
                int remaining = retries;
                while (remaining > 0) {
                    try {
                        action.accept(r, s);
                        return;
                    }
                    catch (Exception e) {
                        if (remaining-- <= 0) {
                            throw e;
                        }
                        r.revert();
                        r.refresh();
                        Thread.sleep(pausePerRetry);
                    }
                }
            }
        };
    }

    public BiConsumer<ResourceResolver, String> startSyntheticWorkflows(final SyntheticWorkflowModel model) {
        return new BiConsumer<ResourceResolver, String>(){

            @Override
            public void accept(ResourceResolver r, String path) throws Exception {
                ((Session)r.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
                DeferredActions.this.nameThread("synWf-" + path);
                DeferredActions.this.workflowRunner.execute(r, path, model, false, false);
            }
        };
    }

    public BiConsumer<ResourceResolver, String> removeAllRenditions() {
        return new BiConsumer<ResourceResolver, String>(){

            @Override
            public void accept(ResourceResolver r, String path) {
                DeferredActions.this.nameThread("removeRenditions-" + path);
                AssetManager assetManager = (AssetManager)r.adaptTo(AssetManager.class);
                Asset asset = assetManager.getAsset(path);
                Iterator renditions = asset.listRenditions();
                while (renditions.hasNext()) {
                    Rendition rendition = (Rendition)renditions.next();
                    if (rendition.getName().equalsIgnoreCase("original")) continue;
                    asset.removeRendition(rendition.getName());
                }
            }
        };
    }

    public BiConsumer<ResourceResolver, String> removeAllRenditionsNamed(final String name) {
        return new BiConsumer<ResourceResolver, String>(){

            @Override
            public void accept(ResourceResolver r, String path) {
                DeferredActions.this.nameThread("removeRenditions-" + path);
                AssetManager assetManager = (AssetManager)r.adaptTo(AssetManager.class);
                Asset asset = assetManager.getAsset(path);
                Iterator renditions = asset.listRenditions();
                while (renditions.hasNext()) {
                    Rendition rendition = (Rendition)renditions.next();
                    if (!rendition.getName().equalsIgnoreCase(name)) continue;
                    asset.removeRendition(rendition.getName());
                }
            }
        };
    }

    public BiConsumer<ResourceResolver, String> activateAll() {
        return new BiConsumer<ResourceResolver, String>(){

            @Override
            public void accept(ResourceResolver r, String path) throws ReplicationException {
                DeferredActions.this.nameThread("activate-" + path);
                DeferredActions.this.replicator.replicate((Session)r.adaptTo(Session.class), ReplicationActionType.ACTIVATE, path);
            }
        };
    }

    public BiConsumer<ResourceResolver, String> activateAllWithOptions(final ReplicationOptions options) {
        return new BiConsumer<ResourceResolver, String>(){

            @Override
            public void accept(ResourceResolver r, String path) throws ReplicationException {
                DeferredActions.this.nameThread("activate-" + path);
                DeferredActions.this.replicator.replicate((Session)r.adaptTo(Session.class), ReplicationActionType.ACTIVATE, path, options);
            }
        };
    }

    public BiConsumer<ResourceResolver, String> deactivateAll() {
        return new BiConsumer<ResourceResolver, String>(){

            @Override
            public void accept(ResourceResolver r, String path) throws ReplicationException {
                DeferredActions.this.nameThread("deactivate-" + path);
                DeferredActions.this.replicator.replicate((Session)r.adaptTo(Session.class), ReplicationActionType.DEACTIVATE, path);
            }
        };
    }

    public BiConsumer<ResourceResolver, String> deactivateAllWithOptions(final ReplicationOptions options) {
        return new BiConsumer<ResourceResolver, String>(){

            @Override
            public void accept(ResourceResolver r, String path) throws ReplicationException {
                DeferredActions.this.nameThread("deactivate-" + path);
                DeferredActions.this.replicator.replicate((Session)r.adaptTo(Session.class), ReplicationActionType.DEACTIVATE, path, options);
            }
        };
    }

    public Consumer<ResourceResolver> retry(final int retries, final long pausePerRetry, final Consumer<ResourceResolver> action) {
        return new Consumer<ResourceResolver>(){

            @Override
            public void accept(ResourceResolver r) throws Exception {
                int remaining = retries;
                while (remaining > 0) {
                    try {
                        action.accept(r);
                        return;
                    }
                    catch (Exception e) {
                        if (remaining-- <= 0) {
                            throw e;
                        }
                        r.revert();
                        r.refresh();
                        Thread.sleep(pausePerRetry);
                    }
                }
            }
        };
    }

    public final Consumer<ResourceResolver> startSyntheticWorkflow(SyntheticWorkflowModel model, String path) {
        return this.createSingleAction(this.startSyntheticWorkflows(model), path);
    }

    public final Consumer<ResourceResolver> removeRenditions(String path) {
        return this.createSingleAction(this.removeAllRenditions(), path);
    }

    public final Consumer<ResourceResolver> removeRenditionsNamed(String path, String name) {
        return this.createSingleAction(this.removeAllRenditionsNamed(name), path);
    }

    public final Consumer<ResourceResolver> activate(String path) {
        return this.createSingleAction(this.activateAll(), path);
    }

    public final Consumer<ResourceResolver> activateWithOptions(String path, ReplicationOptions options) {
        return this.createSingleAction(this.activateAllWithOptions(options), path);
    }

    public final Consumer<ResourceResolver> deactivate(String path) {
        return this.createSingleAction(this.deactivateAll(), path);
    }

    public final Consumer<ResourceResolver> deactivateWithOptions(String path, ReplicationOptions options) {
        return this.createSingleAction(this.deactivateAllWithOptions(options), path);
    }

    private void nameThread(String string) {
        Thread.currentThread().setName(string);
    }

    private Consumer<ResourceResolver> createSingleAction(final BiConsumer<ResourceResolver, String> action, final String path) {
        return new Consumer<ResourceResolver>(){

            @Override
            public void accept(ResourceResolver res) throws Exception {
                action.accept(res, path);
            }
        };
    }

    protected void bindWorkflowRunner(SyntheticWorkflowRunner syntheticWorkflowRunner) {
        this.workflowRunner = syntheticWorkflowRunner;
    }

    protected void unbindWorkflowRunner(SyntheticWorkflowRunner syntheticWorkflowRunner) {
        if (this.workflowRunner == syntheticWorkflowRunner) {
            this.workflowRunner = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }
}

