/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.ActionManagerFactory;
import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.fam.impl.ActionManagerImpl;
import com.adobe.acs.commons.fam.mbean.ActionManagerMBean;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;

@Component
@Service(value={ActionManagerFactory.class})
@Property(name="jmx.objectname", value={"com.adobe.acs.commons:type=Action Manager"})
public class ActionManagerFactoryImpl
extends AnnotatedStandardMBean
implements ActionManagerFactory {
    @Reference
    ThrottledTaskRunner taskRunner;
    private final Map<String, ActionManagerImpl> tasks = new HashMap<String, ActionManagerImpl>();

    public ActionManagerFactoryImpl() throws NotCompliantMBeanException {
        super(ActionManagerMBean.class);
    }

    @Override
    public ActionManager createTaskManager(String name, ResourceResolver resourceResolver, int saveInterval) throws LoginException {
        String tryName = name;
        int counter = 1;
        while (this.tasks.containsKey(tryName)) {
            tryName = name + " (" + ++counter + ")";
        }
        name = tryName;
        ActionManagerImpl manager = new ActionManagerImpl(name, this.taskRunner, resourceResolver, saveInterval);
        this.tasks.put(tryName, manager);
        return manager;
    }

    @Override
    public TabularDataSupport getStatistics() throws OpenDataException {
        TabularDataSupport stats = new TabularDataSupport(ActionManagerImpl.getStaticsTableType());
        for (ActionManagerImpl task : this.tasks.values()) {
            stats.put(task.getStatistics());
        }
        return stats;
    }

    @Override
    public TabularDataSupport getFailures() throws OpenDataException {
        TabularDataSupport stats = new TabularDataSupport(ActionManagerImpl.getFailuresTableType());
        for (ActionManagerImpl task : this.tasks.values()) {
            stats.putAll(task.getFailures().toArray(new CompositeData[0]));
        }
        return stats;
    }

    @Override
    public void purgeCompletedTasks() {
        Iterator<ActionManagerImpl> taskIterator = this.tasks.values().iterator();
        while (taskIterator.hasNext()) {
            ActionManagerImpl task = taskIterator.next();
            if (!task.isComplete() && this.taskRunner.getActiveCount() != 0L) continue;
            task.closeAllResolvers();
            taskIterator.remove();
        }
    }

    protected void bindTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        this.taskRunner = throttledTaskRunner;
    }

    protected void unbindTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        if (this.taskRunner == throttledTaskRunner) {
            this.taskRunner = null;
        }
    }
}

