/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.Failure;
import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.fam.impl.ReusableResolver;
import com.adobe.acs.commons.functions.BiConsumer;
import com.adobe.acs.commons.functions.BiFunction;
import com.adobe.acs.commons.functions.Consumer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActionManagerImpl
implements ActionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ActionManagerImpl.class);
    private final AtomicInteger tasksAdded = new AtomicInteger();
    private final AtomicInteger tasksCompleted = new AtomicInteger();
    private final AtomicInteger tasksFilteredOut = new AtomicInteger();
    private final AtomicInteger tasksSuccessful = new AtomicInteger();
    private final AtomicInteger tasksError = new AtomicInteger();
    private final String name;
    private final long started;
    private long finished;
    private final Deque<ReusableResolver> resolvers = new ConcurrentLinkedDeque<ReusableResolver>();
    private final ThrottledTaskRunner taskRunner;
    private final ThreadLocal<String> currentPath;
    private final List<Failure> failures;
    private int resolverCount = 0;
    private static String[] statsItemNames;
    private static CompositeType statsCompositeType;
    private static TabularType statsTabularType;
    private static String[] failureItemNames;
    private static CompositeType failureCompositeType;
    private static TabularType failureTabularType;

    ActionManagerImpl(String name, ThrottledTaskRunner taskRunner, ResourceResolver resolver, int saveInterval) throws LoginException {
        this.name = name;
        this.taskRunner = taskRunner;
        this.initResolverPool(resolver, saveInterval);
        this.started = System.currentTimeMillis();
        this.currentPath = new ThreadLocal();
        this.failures = new ArrayList<Failure>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Failure> getFailureList() {
        return this.failures;
    }

    @Override
    public void deferredWithResolver(Consumer<ResourceResolver> action) {
        this.deferredWithResolver(action, false);
    }

    @Override
    public void withResolver(Consumer<ResourceResolver> action) throws Exception {
        this.withResolver(action, false);
    }

    @Override
    public int withQueryResults(final String queryStatement, final String language, final BiConsumer<ResourceResolver, String> callback, final BiFunction<ResourceResolver, String, Boolean> ... filters) throws RepositoryException, PersistenceException, Exception {
        this.withResolver(new Consumer<ResourceResolver>(){

            @Override
            public void accept(ResourceResolver resolver) {
                try {
                    Session session = (Session)resolver.adaptTo(Session.class);
                    QueryManager queryManager = session.getWorkspace().getQueryManager();
                    Query query = queryManager.createQuery(queryStatement, language);
                    QueryResult results = query.execute();
                    NodeIterator nodeIterator = results.getNodes();
                    while (nodeIterator.hasNext()) {
                        final String nodePath = nodeIterator.nextNode().getPath();
                        LOG.info("Processing found result " + nodePath);
                        ActionManagerImpl.this.deferredWithResolver(new Consumer<ResourceResolver>(){

                            @Override
                            public void accept(ResourceResolver r) throws Exception {
                                ActionManagerImpl.this.currentPath.set(nodePath);
                                if (filters != null) {
                                    for (BiFunction filter : filters) {
                                        if (((Boolean)filter.apply(r, nodePath)).booleanValue()) continue;
                                        ActionManagerImpl.this.logFilteredOutItem(nodePath);
                                        return;
                                    }
                                }
                                callback.accept(r, nodePath);
                            }
                        });
                    }
                }
                catch (RepositoryException ex) {
                    LOG.error("Repository exception processing query " + queryStatement, (Throwable)ex);
                }
            }
        }, false);
        return this.tasksAdded.get();
    }

    @Override
    public void addCleanupTask() {
        for (int i = 0; i < this.resolverCount; ++i) {
            this.deferredWithResolver(new Consumer<ResourceResolver>(){

                @Override
                public void accept(ResourceResolver t) {
                    try {
                        t.commit();
                        t.close();
                    }
                    catch (PersistenceException ex) {
                        LOG.error("Persistence exception closing session pool", (Throwable)ex);
                    }
                }
            }, true);
        }
    }

    @Override
    public void setCurrentItem(String item) {
        this.currentPath.set(item);
    }

    private void deferredWithResolver(final Consumer<ResourceResolver> action, final boolean closesResolver) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        ActionManagerImpl.this.withResolver(action, closesResolver);
                        if (!closesResolver) {
                            ActionManagerImpl.this.logCompletetion();
                        }
                    }
                    catch (Exception ex) {
                        if (closesResolver) break block3;
                        ActionManagerImpl.this.logError(ex);
                    }
                }
            }
        };
        this.taskRunner.scheduleWork(r);
        if (!closesResolver) {
            this.tasksAdded.incrementAndGet();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void withResolver(Consumer<ResourceResolver> action, boolean closesResolver) throws Exception {
        ReusableResolver resolver = null;
        while (resolver == null || !resolver.getResolver().isLive()) {
            if (!this.resolvers.isEmpty()) {
                resolver = this.resolvers.remove();
            }
            if (resolver != null) continue;
            if (closesResolver) return;
            this.logError((Exception)((Object)new RepositoryException("No available resource resolvers in pool!")));
            return;
        }
        resolver.setCurrentItem(this.currentPath.get());
        try {
            action.accept(resolver.getResolver());
            return;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            try {
                resolver.free();
            }
            catch (PersistenceException ex) {
                this.logPersistenceException(resolver.getPendingItems(), ex);
                throw ex;
            }
            finally {
                if (!closesResolver) {
                    this.resolvers.push(resolver);
                }
            }
        }
    }

    private void initResolverPool(ResourceResolver source, int saveInterval) throws LoginException {
        this.resolverCount = Math.max(this.taskRunner.getMaxThreads(), 32);
        for (int i = 0; i < this.resolverCount; ++i) {
            this.resolvers.push(new ReusableResolver(source.clone(null), saveInterval));
        }
    }

    private void logCompletetion() {
        this.tasksCompleted.incrementAndGet();
        this.tasksSuccessful.incrementAndGet();
        if (this.isComplete()) {
            this.finished = System.currentTimeMillis();
        }
    }

    private void logError(Exception ex) {
        LOG.error("Caught exception in task: " + ex.getMessage(), (Throwable)ex);
        Failure fail = new Failure();
        fail.setNodePath(this.currentPath.get());
        fail.setException(ex);
        this.failures.add(fail);
        this.tasksCompleted.incrementAndGet();
        this.tasksError.incrementAndGet();
        if (this.isComplete()) {
            this.finished = System.currentTimeMillis();
        }
    }

    private void logPersistenceException(List<String> items, PersistenceException ex) {
        StringBuilder itemList = new StringBuilder();
        for (String item : items) {
            itemList.append(item).append("; ");
            Failure fail = new Failure();
            fail.setNodePath(item);
            fail.setException((Exception)((Object)ex));
            this.failures.add(fail);
            this.tasksError.incrementAndGet();
            this.tasksSuccessful.decrementAndGet();
        }
        LOG.error("Persistence error prevented saving changes for: " + itemList, (Throwable)ex);
    }

    private void logFilteredOutItem(String path) {
        this.tasksFilteredOut.incrementAndGet();
        LOG.info("Filtered out " + path);
    }

    private long getRuntime() {
        if (this.isComplete()) {
            return this.finished - this.started;
        }
        return System.currentTimeMillis() - this.started;
    }

    public static TabularType getStaticsTableType() {
        return statsTabularType;
    }

    @Override
    public boolean isComplete() {
        return this.tasksCompleted.get() == this.tasksAdded.get();
    }

    @Override
    public CompositeData getStatistics() throws OpenDataException {
        return new CompositeDataSupport(statsCompositeType, statsItemNames, new Object[]{this.name, this.tasksAdded.get(), this.tasksCompleted.get(), this.tasksFilteredOut.get(), this.tasksSuccessful.get(), this.tasksError.get(), this.getRuntime()});
    }

    @Override
    public void closeAllResolvers() {
        if (!this.resolvers.isEmpty()) {
            for (ReusableResolver resolver : this.resolvers) {
                resolver.getResolver().close();
            }
            this.resolvers.clear();
        }
    }

    public static TabularType getFailuresTableType() {
        return failureTabularType;
    }

    @Override
    public List<CompositeData> getFailures() throws OpenDataException {
        ArrayList<CompositeData> failureData = new ArrayList<CompositeData>();
        int count = 0;
        for (Failure fail : this.failures) {
            if (count > 5000) break;
            failureData.add(new CompositeDataSupport(failureCompositeType, failureItemNames, new Object[]{this.name, ++count, fail.getNodePath(), fail.getException().getMessage()}));
        }
        return failureData;
    }

    static {
        try {
            statsItemNames = new String[]{"_taskName", "started", "completed", "filtered", "successful", "errors", "runtime"};
            statsCompositeType = new CompositeType("Statics Row", "Single row of statistics", statsItemNames, new String[]{"Name", "Started", "Completed", "Filtered", "Successful", "Errors", "Runtime"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG});
            statsTabularType = new TabularType("Statistics", "Collected statistics", statsCompositeType, new String[]{"_taskName"});
            failureItemNames = new String[]{"_taskName", "_count", "item", "error"};
            failureCompositeType = new CompositeType("Failure", "Failure", failureItemNames, new String[]{"Name", "#", "Item", "Error"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING});
            failureTabularType = new TabularType("Errors", "Collected failures", failureCompositeType, new String[]{"_taskName", "_count"});
        }
        catch (OpenDataException ex) {
            LOG.error("Unable to build MBean composite types", (Throwable)ex);
        }
    }
}

