/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;

public class RunningStatistic {
    private static int rollingAverageWidth = 20;
    private final String name;
    private final AtomicLong counter = new AtomicLong();
    private final AtomicLong min = new AtomicLong();
    private final AtomicLong max = new AtomicLong();
    private double total;
    private double rollingCounter;
    private List<Long> rollingSeries;
    private static String[] itemNames;
    private static CompositeType compositeType;
    private static TabularType tabularType;

    public RunningStatistic(String name) {
        this.name = name;
        this.reset();
    }

    public synchronized void log(long l) {
        this.total += (double)l;
        this.counter.incrementAndGet();
        this.rollingCounter += (double)l;
        this.rollingSeries.add(l);
        this.rollingCounter -= (double)this.rollingSeries.remove(0).longValue();
        this.min.set(Math.min(this.min.get(), l));
        this.max.set(Math.max(this.max.get(), l));
    }

    public void reset() {
        this.rollingSeries = Collections.synchronizedList(new LinkedList());
        for (int i = 0; i < rollingAverageWidth; ++i) {
            this.rollingSeries.add(0L);
        }
        this.counter.set(0L);
        this.rollingCounter = 0.0;
        this.total = 0.0;
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
    }

    public long getMin() {
        return this.min.get();
    }

    public long getMax() {
        return this.max.get();
    }

    public double getMean() {
        return this.total / (double)this.counter.get();
    }

    public double getRollingMean() {
        return this.rollingCounter / (double)rollingAverageWidth;
    }

    public CompositeData getStatistics() throws OpenDataException {
        return new CompositeDataSupport(compositeType, itemNames, new Object[]{this.name, this.min.get(), this.max.get(), this.getMean(), this.getRollingMean()});
    }

    public static TabularType getStaticsTableType() {
        return tabularType;
    }

    static {
        try {
            itemNames = new String[]{"attribute", "min", "max", "mean", "rolling mean"};
            compositeType = new CompositeType("Statics Row", "Single row of statistics", itemNames, new String[]{"Name", "Minimum value", "Maximum value", "Overall average", "Average of last " + rollingAverageWidth}, new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.DOUBLE, SimpleType.DOUBLE});
            tabularType = new TabularType("Statistics", "Collected statistics", compositeType, new String[]{"attribute"});
        }
        catch (OpenDataException ex) {
            Logger.getLogger(RunningStatistic.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

