/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedRunnable
implements Runnable {
    long created = System.currentTimeMillis();
    long started = -1L;
    long executed = -1L;
    long finished = -1L;
    Runnable work;
    ThrottledTaskRunner runner;
    int timeout;
    TimeUnit timeoutUnit;
    private static final Logger LOG = LoggerFactory.getLogger(TimedRunnable.class);

    public TimedRunnable(Runnable work, ThrottledTaskRunner runner, int timeout, TimeUnit timeoutUnit) {
        this.work = work;
        this.runner = runner;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        LOG.debug("Task created");
    }

    @Override
    public void run() {
        final Thread thisThread = Thread.currentThread();
        final Semaphore timerSemaphore = new Semaphore(0);
        Thread watchDog = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean finished = false;
                try {
                    finished = timerSemaphore.tryAcquire(TimedRunnable.this.timeout, TimedRunnable.this.timeoutUnit);
                }
                catch (InterruptedException ex) {
                    LOG.error("Watchdog thread interrupted", (Throwable)ex);
                }
                if (!finished) {
                    thisThread.interrupt();
                }
            }
        });
        boolean successful = false;
        Throwable error = null;
        try {
            this.started = System.currentTimeMillis();
            this.runner.waitForLowCpuAndLowMemory();
            this.executed = System.currentTimeMillis();
            if (this.timeout > 0) {
                watchDog.start();
            }
            this.work.run();
            this.finished = System.currentTimeMillis();
            timerSemaphore.release();
            successful = true;
        }
        catch (Throwable ex) {
            this.finished = System.currentTimeMillis();
            LOG.error("Task encountered an uncaught exception", ex);
        }
        this.runner.logCompletion(this.created, this.started, this.executed, this.finished, successful, error);
    }
}

