/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.forms.helpers.impl;

import com.adobe.acs.commons.forms.Form;
import com.adobe.acs.commons.forms.FormsRouter;
import com.adobe.acs.commons.forms.impl.FormImpl;
import com.day.cq.wcm.api.Page;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.xss.XSSAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
@Property(name="service.ranking", intValue={-2147483648})
public abstract class AbstractFormHelperImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractFormHelperImpl.class);
    static final String[] FORM_INPUTS = new String[]{":form", ":formResource"};
    @Reference
    private FormsRouter formsRouter;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private XSSAPI xss;

    public final String getFormInputsHTML(Form form, String ... keys) {
        StringBuffer html = new StringBuffer();
        html.append("<input type=\"hidden\" name=\"").append(":form").append("\" value=\"").append(this.xss.encodeForHTMLAttr(form.getName())).append("\"/>\n");
        String resourcePath = form.getResourcePath();
        html.append("<input type=\"hidden\" name=\"").append(":formResource").append("\" value=\"").append(this.xss.encodeForHTMLAttr(resourcePath)).append("\"/>\n");
        for (String key : keys) {
            if (!form.has(key)) continue;
            html.append("<input type=\"hidden\" name=\"").append(key).append("\" value=\"").append(form.get(key)).append("\"/>\n");
        }
        return html.toString();
    }

    public final String getAction(Page page) {
        return this.getAction(page.getPath());
    }

    public final String getAction(Resource resource) {
        return this.getAction(resource.getPath());
    }

    public final String getAction(String path) {
        return this.getAction(path, null);
    }

    public final String getAction(Page page, String formSelector) {
        return this.getAction(page.getPath(), formSelector);
    }

    public final String getAction(Resource resource, String formSelector) {
        return this.getAction(resource.getPath(), formSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getAction(String path, String formSelector) {
        String actionPath = path;
        ResourceResolver adminResourceResolver = null;
        try {
            adminResourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            actionPath = adminResourceResolver.map(path);
        }
        catch (LoginException e) {
            log.error("Could not attain an admin ResourceResolver to map the Form's Action URI");
        }
        finally {
            if (adminResourceResolver != null && adminResourceResolver.isLive()) {
                adminResourceResolver.close();
            }
        }
        actionPath = actionPath + ".html" + this.getSuffix();
        if (StringUtils.isNotBlank((String)formSelector)) {
            actionPath = actionPath + "/" + formSelector;
        }
        return actionPath;
    }

    public final String getSuffix() {
        return this.formsRouter.getSuffix();
    }

    protected final boolean doHandlePost(String formName, SlingHttpServletRequest request) {
        if (StringUtils.equalsIgnoreCase((String)"POST", (String)request.getMethod())) {
            return StringUtils.equals((String)formName, (String)request.getParameter(this.getPostLookupKey(formName)));
        }
        return false;
    }

    protected final Form getPostForm(String formName, SlingHttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        RequestParameterMap requestMap = request.getRequestParameterMap();
        block0: for (String key : requestMap.keySet()) {
            if (StringUtils.equals((String)key, (String)this.getPostLookupKey(null))) continue;
            RequestParameter[] values = requestMap.getValues(key);
            if (values == null || values.length == 0) {
                log.debug("Value did not exist for key: {}", (Object)key);
                continue;
            }
            if (values.length == 1) {
                log.debug("Adding to form data: {} ~> {}", (Object)key, (Object)values[0].toString());
                map.put(key, values[0].getString());
                continue;
            }
            for (RequestParameter value : values) {
                String tmp = value.toString();
                map.put(key, tmp);
                if (StringUtils.isNotBlank((String)tmp)) continue block0;
            }
        }
        return this.clean(new FormImpl(formName, request.getResource().getPath(), map));
    }

    protected final String getPostLookupKey(String formName) {
        return ":form";
    }

    protected final Form clean(Form form) {
        Map<String, String> map = form.getData();
        HashMap<String, String> cleanedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (ArrayUtils.contains((Object[])FORM_INPUTS, (Object)entry.getKey()) || !StringUtils.isNotBlank((String)entry.getValue())) continue;
            cleanedMap.put(entry.getKey(), entry.getValue());
        }
        return new FormImpl(form.getName(), form.getResourcePath(), cleanedMap, form.getErrors());
    }

    protected final Form getProtectedForm(Form form) {
        return new FormImpl(form.getName(), form.getResourcePath(), this.getProtectedData(form.getData()), this.getProtectedErrors(form.getErrors()));
    }

    protected final Map<String, String> getProtectedData(Map<String, String> data) {
        HashMap<String, String> protectedData = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            protectedData.put(entry.getKey(), this.xss.encodeForHTMLAttr(entry.getValue()));
        }
        return protectedData;
    }

    protected final Map<String, String> getProtectedErrors(Map<String, String> errors) {
        HashMap<String, String> protectedErrors = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : errors.entrySet()) {
            protectedErrors.put(entry.getKey(), this.xss.encodeForHTML(entry.getValue()));
        }
        return protectedErrors;
    }

    public final boolean hasValidSuffix(SlingHttpServletRequest slingRequest) {
        return this.formsRouter.hasValidSuffix(slingRequest);
    }

    public final String getFormSelector(SlingHttpServletRequest slingRequest) {
        return this.formsRouter.getFormSelector(slingRequest);
    }

    protected String encode(String unencoded) {
        if (StringUtils.isBlank((String)unencoded)) {
            return "";
        }
        try {
            return URLEncoder.encode(unencoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return unencoded;
        }
    }

    protected String decode(String encoded) {
        if (StringUtils.isBlank((String)encoded)) {
            return "";
        }
        try {
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return encoded;
        }
    }

    protected void bindFormsRouter(FormsRouter formsRouter) {
        this.formsRouter = formsRouter;
    }

    protected void unbindFormsRouter(FormsRouter formsRouter) {
        if (this.formsRouter == formsRouter) {
            this.formsRouter = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindXss(XSSAPI xSSAPI) {
        this.xss = xSSAPI;
    }

    protected void unbindXss(XSSAPI xSSAPI) {
        if (this.xss == xSSAPI) {
            this.xss = null;
        }
    }
}

