/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.forms.helpers.impl;

import com.adobe.acs.commons.forms.Form;
import com.adobe.acs.commons.forms.helpers.FormHelper;
import com.adobe.acs.commons.forms.helpers.PostRedirectGetWithCookiesFormHelper;
import com.adobe.acs.commons.forms.helpers.impl.PostRedirectGetFormHelperImpl;
import com.adobe.acs.commons.util.CookieUtil;
import com.day.cq.wcm.api.Page;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.http.Cookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true)
@Property(label="Service Ranking", name="service.ranking", intValue={400})
@Service(value={FormHelper.class, PostRedirectGetWithCookiesFormHelper.class})
public class PostRedirectGetWithCookiesFormHelperImpl
extends PostRedirectGetFormHelperImpl
implements PostRedirectGetWithCookiesFormHelper {
    private static final Logger log = LoggerFactory.getLogger(PostRedirectGetWithCookiesFormHelperImpl.class);
    public static final int COOKIE_MAX_AGE = 600;
    public static final String ROOT_COOKIE_PATH = "/";

    @Override
    public final void sendRedirect(Form form, String path, String formSelector, SlingHttpServletResponse response) throws IOException, JSONException {
        String url = this.getRedirectPath(form, path, formSelector);
        this.addFlashCookie(response, form);
        response.sendRedirect(url);
    }

    @Override
    public final void sendRedirect(Form form, Page page, String formSelector, SlingHttpServletResponse response) throws IOException, JSONException {
        String url = this.getRedirectPath(form, page, formSelector);
        this.addFlashCookie(response, form);
        response.sendRedirect(url);
    }

    @Override
    public final void sendRedirect(Form form, Resource resource, String formSelector, SlingHttpServletResponse response) throws IOException, JSONException {
        String url = this.getRedirectPath(form, resource, formSelector);
        this.addFlashCookie(response, form);
        response.sendRedirect(url);
    }

    @Override
    protected final boolean doHandleGet(String formName, SlingHttpServletRequest request) {
        if (StringUtils.equalsIgnoreCase((String)"GET", (String)request.getMethod())) {
            return CookieUtil.getCookie((HttpServletRequest)request, this.getGetLookupKey(formName)) != null;
        }
        return false;
    }

    @Override
    protected String getRawFormData(String formName, SlingHttpServletRequest request, SlingHttpServletResponse response) {
        String cookieName = this.getGetLookupKey(formName);
        javax.servlet.http.Cookie cookie = CookieUtil.getCookie((HttpServletRequest)request, cookieName);
        String data = "";
        if (response != null && cookie != null) {
            CookieUtil.dropCookies((HttpServletRequest)request, (HttpServletResponse)response, ROOT_COOKIE_PATH, cookieName);
            data = this.decode(cookie.getValue());
        } else {
            log.warn("SlingHttpServletResponse required for removing cookie. Please use formHelper.getForm({}, slingRequest, slingResponse);", (Object)formName);
        }
        return data;
    }

    @Override
    protected final String getRedirectPath(Form form, String path, String formSelector) throws JSONException {
        String redirectPath = path;
        redirectPath = redirectPath + this.getSuffix();
        if (StringUtils.isNotBlank((String)formSelector)) {
            redirectPath = redirectPath + ROOT_COOKIE_PATH + formSelector;
        }
        return redirectPath;
    }

    @Override
    protected final String encode(String unencoded) {
        return StringUtils.isBlank((String)unencoded) ? "" : Cookie.escape((String)unencoded);
    }

    @Override
    protected final String decode(String encoded) {
        return StringUtils.isBlank((String)encoded) ? "" : Cookie.unescape((String)encoded);
    }

    protected void addFlashCookie(SlingHttpServletResponse response, Form form) throws JSONException {
        String name = this.getGetLookupKey(form.getName());
        String value = this.getQueryParameterValue(form);
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(name, value);
        cookie.setMaxAge(600);
        CookieUtil.addCookie(cookie, (HttpServletResponse)response);
    }
}

