/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheRepositoryAccessException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import com.adobe.acs.commons.httpcache.util.UserUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - Cache config", description="Config for request URI patterns that have to be cached.", configurationFactory=true, metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Order: {httpcache.config.order}, Request URIs: {httpcache.config.requesturi.patterns}, Request URIs blacklist: {httpcache.config.requesturi.patterns.blacklisted}, Authentication: {httpcache.config.request.authentication}, Invalidation paths: {httpcache.config.invalidation.oak.paths}, Cache type: {httpcache.config.cachestore}"}, propertyPrivate=true)})
@Service
public class HttpCacheConfigImpl
implements HttpCacheConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheConfigImpl.class);
    public static final int DEFAULT_ORDER = 1000;
    private int order = 1000;
    @Property(label="Priority order", description="Order in which the HttpCacheEngine should evaluate the HttpCacheConfigs against the request. Evaluates smallest to largest (Integer.MIN_VALUE -> Integer.MAX_VALUE). Defaults to 1000 ", intValue={1000})
    public static final String PROP_ORDER = "httpcache.config.order";
    @Property(label="Request URI patterns", description="Request URI patterns (REGEX) to be cached. Example - /content/mysite(.*).product-data.json. Mandatory parameter.", cardinality=0x7FFFFFFF)
    private static final String PROP_REQUEST_URI_PATTERNS = "httpcache.config.requesturi.patterns";
    private List<String> requestUriPatterns;
    private List<Pattern> requestUriPatternsAsRegEx;
    @Property(label="Blacklisted request URI patterns", description="Blacklisted request URI patterns (REGEX). Evaluated post applying the above request uri patterns (httpcache.config.requesturi.patterns). Optional parameter.", cardinality=0x7FFFFFFF)
    private static final String PROP_BLACKLISTED_REQUEST_URI_PATTERNS = "httpcache.config.requesturi.patterns.blacklisted";
    private List<String> blacklistedRequestUriPatterns;
    private List<Pattern> blacklistedRequestUriPatternsAsRegEx;
    @Property(label="Authentication", description="Authentication requirement.", options={@PropertyOption(name="anonymous", value="anonymous"), @PropertyOption(name="authenticated", value="authenticated"), @PropertyOption(name="both", value="both")}, value={"anonymous"})
    private static final String PROP_AUTHENTICATION_REQUIREMENT = "httpcache.config.request.authentication";
    private static final String DEFAULT_AUTHENTICATION_REQUIREMENT = "anonymous";
    private String authenticationRequirement;
    @Property(label="JCR path pattern (REGEX) for cache invalidation ", description="Optional set of paths in JCR (Oak) repository for which this cache has to be invalidated. This accepts REGEX. Example - /etc/my-products(.*)", cardinality=0x7FFFFFFF)
    private static final String PROP_CACHE_INVALIDATION_PATH_PATTERNS = "httpcache.config.invalidation.oak.paths";
    private List<String> cacheInvalidationPathPatterns;
    private List<Pattern> cacheInvalidationPathPatternsAsRegEx;
    @Property(label="Cache store", description="Cache store for caching the response for this request URI. Example - MEM. This should be one of the cache stores active in this installation. Mandatory parameter.", propertyPrivate=true, options={@PropertyOption(name="MEM", value="MEM"), @PropertyOption(name="DISK", value="DISK"), @PropertyOption(name="JCR", value="JCR")}, value={"MEM"})
    private static final String PROP_CACHE_STORE = "httpcache.config.cachestore";
    private static final String DEFAULT_CACHE_STORE = "MEM";
    private String cacheStore;
    @Property(name="cacheConfigExtension.target", label="HttpCacheConfigExtension service pid", description="Service pid of target implementation of HttpCacheConfigExtension to be used. Example - (service.pid=com.adobe.acs.commons.httpcache.config.impl.GroupHttpCacheConfigExtension). Optional parameter.", value={"(service.pid=com.adobe.acs.commons.httpcache.config.impl.GroupHttpCacheConfigExtension)"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, name="cacheConfigExtension")
    private HttpCacheConfigExtension cacheConfigExtension;
    @Property(name="cacheKeyFactory.target", label="CacheKeyFactory service pid", description="Service pid of target implementation of CacheKeyFactory to be used. Example - (service.pid=com.adobe.acs.commons.httpcac`he.config.impl.GroupHttpCacheConfigExtension). Mandatory parameter.", value={"(service.pid=com.adobe.acs.commons.httpcache.config.impl.GroupHttpCacheConfigExtension)"})
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC, name="cacheKeyFactory")
    private CacheKeyFactory cacheKeyFactory;
    @Property(label="Config-specific HttpCacheHandlingRules", description="List of Service pid of HttpCacheHandlingRule applicable for this cache config. Optional parameter", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_CACHE_HANDLING_RULES_PID = "httpcache.config.cache-handling-rules.pid";
    private List<String> cacheHandlingRulesPid;

    @Activate
    protected void activate(Map<String, Object> configs) {
        this.requestUriPatterns = Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_REQUEST_URI_PATTERNS), (String[])new String[0]));
        this.requestUriPatternsAsRegEx = this.compileToPatterns(this.requestUriPatterns);
        this.blacklistedRequestUriPatterns = Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_BLACKLISTED_REQUEST_URI_PATTERNS), (String[])new String[0]));
        this.blacklistedRequestUriPatternsAsRegEx = this.compileToPatterns(this.blacklistedRequestUriPatterns);
        this.authenticationRequirement = PropertiesUtil.toString((Object)configs.get(PROP_AUTHENTICATION_REQUIREMENT), (String)DEFAULT_AUTHENTICATION_REQUIREMENT);
        this.cacheStore = PropertiesUtil.toString((Object)configs.get(PROP_CACHE_STORE), (String)DEFAULT_CACHE_STORE);
        this.cacheInvalidationPathPatterns = Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_CACHE_INVALIDATION_PATH_PATTERNS), (String[])new String[0]));
        this.cacheInvalidationPathPatternsAsRegEx = this.compileToPatterns(this.cacheInvalidationPathPatterns);
        this.order = PropertiesUtil.toInteger((Object)configs.get(PROP_ORDER), (int)1000);
        this.cacheHandlingRulesPid = new ArrayList<String>(Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_CACHE_HANDLING_RULES_PID), (String[])new String[0])));
        ListIterator<String> listIterator = this.cacheHandlingRulesPid.listIterator();
        while (listIterator.hasNext()) {
            String value = listIterator.next();
            if (!StringUtils.isBlank((String)value)) continue;
            listIterator.remove();
        }
        log.info("HttpCacheConfigImpl activated.");
    }

    private List<Pattern> compileToPatterns(List<String> regexes) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String regex : regexes) {
            if (!StringUtils.isNotBlank((String)regex)) continue;
            patterns.add(Pattern.compile(regex));
        }
        return patterns;
    }

    @Deactivate
    protected void deactivate(Map<String, Object> configs) {
        log.info("HttpCacheConfigImpl deactivated.");
    }

    @Override
    public String getCacheStoreName() {
        return this.cacheStore;
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request) throws HttpCacheRepositoryAccessException {
        String uri;
        if (UserUtils.isAnonymous(request.getResourceResolver().getUserID())) {
            if ("authenticated".equals(this.authenticationRequirement)) {
                log.trace("Rejected: Request is anonymous but the config accepts only authenticated request and hence reject");
                return false;
            }
        } else if (DEFAULT_AUTHENTICATION_REQUIREMENT.equals(this.authenticationRequirement)) {
            log.trace("Rejected: Request is authenticated but config is for anonymous and hence reject.");
            return false;
        }
        if (!this.matches(this.requestUriPatternsAsRegEx, uri = request.getRequestURI())) {
            log.trace("Rejected: Request URI does not match the white-listed URI patterns");
            return false;
        }
        if (this.matches(this.blacklistedRequestUriPatternsAsRegEx, uri)) {
            log.trace("Rejected: Request URI does match a black-listed URI pattern");
            return false;
        }
        if (null != this.cacheConfigExtension) {
            return this.cacheConfigExtension.accepts(request, this);
        }
        return true;
    }

    private boolean matches(List<Pattern> patterns, String data) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(data);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CacheKey buildCacheKey(SlingHttpServletRequest request) throws HttpCacheKeyCreationException {
        return this.cacheKeyFactory.build(request, this);
    }

    @Override
    public boolean isValid() {
        return CollectionUtils.isNotEmpty(this.requestUriPatterns);
    }

    @Override
    public boolean canInvalidate(String path) {
        return this.matches(this.cacheInvalidationPathPatternsAsRegEx, path);
    }

    @Override
    public String getAuthenticationRequirement() {
        return this.authenticationRequirement;
    }

    @Override
    public List<Pattern> getRequestUriPatterns() {
        return this.requestUriPatternsAsRegEx;
    }

    @Override
    public List<Pattern> getBlacklistedRequestUriPatterns() {
        return this.blacklistedRequestUriPatternsAsRegEx;
    }

    @Override
    public List<Pattern> getJCRInvalidationPathPatterns() {
        return this.cacheInvalidationPathPatternsAsRegEx;
    }

    @Override
    public boolean knows(CacheKey key) throws HttpCacheKeyCreationException {
        return this.cacheKeyFactory.doesKeyMatchConfig(key, this);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean acceptsRule(String servicePid) {
        return this.cacheHandlingRulesPid.contains(servicePid);
    }

    protected void bindCacheConfigExtension(HttpCacheConfigExtension httpCacheConfigExtension) {
        this.cacheConfigExtension = httpCacheConfigExtension;
    }

    protected void unbindCacheConfigExtension(HttpCacheConfigExtension httpCacheConfigExtension) {
        if (this.cacheConfigExtension == httpCacheConfigExtension) {
            this.cacheConfigExtension = null;
        }
    }

    protected void bindCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
        this.cacheKeyFactory = cacheKeyFactory;
    }

    protected void unbindCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
        if (this.cacheKeyFactory == cacheKeyFactory) {
            this.cacheKeyFactory = null;
        }
    }
}

