/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.logging.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, label="ACS AEM Commons - JSON Event Logger", description="Logs OSGi Events for any set of topics to an SLF4j Logger Category, as JSON objects.")
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Logger: {event.logger.category} for events matching '{event.filter}' on '{event.topics}'"})})
public class JsonEventLogger
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(JsonEventLogger.class);
    private static final String PROP_TIMESTAMP = "_timestamp";
    private static final String DEFAULT_LEVEL = "INFO";
    @Property(label="Event Topics", unbounded=PropertyUnbounded.ARRAY, description="This value lists the topics handled by this logger. The value is a list of strings. If the string ends with a star, all topics in this package and all subpackages match. If the string does not end with a star, this is assumed to define an exact topic.")
    private static final String OSGI_TOPICS = "event.topics";
    @Property(label="Event Filter", description="LDAP-style event filter query. Leave blank to log all events to the configured topic or topics.")
    private static final String OSGI_FILTER = "event.filter";
    @Property(label="Logger Name", description="The Sling SLF4j Logger Name or Category to send the JSON messages to. Leave empty to disable the logger.")
    private static final String OSGI_CATEGORY = "event.logger.category";
    @Property(label="Logger Level", value={"INFO"}, options={@PropertyOption(name="TRACE", value="Trace"), @PropertyOption(name="DEBUG", value="Debug"), @PropertyOption(name="INFO", value="Information"), @PropertyOption(name="WARN", value="Warnings"), @PropertyOption(name="ERROR", value="Error")}, description="Select the logging level the messages should be sent with.")
    private static final String OSGI_LEVEL = "event.logger.level";
    private String[] topics;
    private String filter;
    private String category;
    private String level;
    private boolean valid;
    private Logger eventLogger;
    private LogLevel logLevel;
    private ServiceRegistration registration;

    private void logEvent(Event event) {
        log.trace("[logEvent] event={}", (Object)event);
        try {
            String message = JsonEventLogger.constructMessage(event);
            if (this.logLevel == LogLevel.ERROR) {
                this.eventLogger.error(message);
            } else if (this.logLevel == LogLevel.WARN) {
                this.eventLogger.warn(message);
            } else if (this.logLevel == LogLevel.INFO) {
                this.eventLogger.info(message);
            } else if (this.logLevel == LogLevel.DEBUG) {
                this.eventLogger.debug(message);
            } else if (this.logLevel == LogLevel.TRACE) {
                this.eventLogger.trace(message);
            }
        }
        catch (JSONException e) {
            log.error("[logEvent] failed to construct log message from event: " + event.toString(), (Throwable)e);
        }
    }

    private boolean isLoggerEnabled() {
        if (this.eventLogger != null && this.logLevel != null) {
            if (this.logLevel == LogLevel.ERROR) {
                return this.eventLogger.isErrorEnabled();
            }
            if (this.logLevel == LogLevel.WARN) {
                return this.eventLogger.isWarnEnabled();
            }
            if (this.logLevel == LogLevel.INFO) {
                return this.eventLogger.isInfoEnabled();
            }
            if (this.logLevel == LogLevel.DEBUG) {
                return this.eventLogger.isDebugEnabled();
            }
            if (this.logLevel == LogLevel.TRACE) {
                return this.eventLogger.isTraceEnabled();
            }
        }
        return false;
    }

    protected static String constructMessage(Event event) throws JSONException {
        JSONObject obj = new JSONObject();
        String[] arr$ = event.getPropertyNames();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String prop;
            Object val = event.getProperty(prop = arr$[i$]);
            Object converted = JsonEventLogger.convertValue(val);
            obj.put(prop, converted == null ? val : converted);
        }
        obj.put(PROP_TIMESTAMP, (Object)ISO8601.format((Calendar)Calendar.getInstance()));
        return obj.toString();
    }

    protected static Object convertValue(Object val) throws JSONException {
        if (val.getClass().isArray()) {
            Object[] vals = (Object[])val;
            JSONArray array = new JSONArray();
            for (Object arrayVal : vals) {
                Object converted = JsonEventLogger.convertValue(arrayVal);
                array.put(converted == null ? arrayVal : converted);
            }
            return array;
        }
        if (val instanceof Collection) {
            JSONArray array = new JSONArray();
            for (Object arrayVal : (Collection)val) {
                Object converted = JsonEventLogger.convertValue(arrayVal);
                array.put(converted == null ? arrayVal : converted);
            }
            return array;
        }
        if (val instanceof Map) {
            Map valMap = (Map)val;
            JSONObject obj = new JSONObject();
            if (valMap.isEmpty()) {
                return obj;
            }
            if (valMap.keySet().iterator().next() instanceof String) {
                for (Map.Entry entry : valMap.entrySet()) {
                    Object converted = JsonEventLogger.convertValue(entry.getValue());
                    obj.put((String)entry.getKey(), converted == null ? entry.getValue() : converted);
                }
            } else {
                for (Map.Entry entry : valMap.entrySet()) {
                    Object converted = JsonEventLogger.convertValue(entry.getValue());
                    obj.put(entry.getKey().toString(), converted == null ? entry.getValue() : converted);
                }
            }
            return obj;
        }
        if (val instanceof Calendar) {
            try {
                return ISO8601.format((Calendar)((Calendar)val));
            }
            catch (IllegalArgumentException e) {
                log.debug("[constructMessage] failed to convert Calendar to ISO8601 String: {}, {}", (Object)e.getMessage(), val);
            }
        } else if (val instanceof Date) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)val);
                return ISO8601.format((Calendar)calendar);
            }
            catch (IllegalArgumentException e) {
                log.debug("[constructMessage] failed to convert Date to ISO8601 String: {}, {}", (Object)e.getMessage(), val);
            }
        }
        return val;
    }

    public void handleEvent(Event event) {
        if (event.getProperty("event.application") == null && this.isLoggerEnabled()) {
            this.logEvent(event);
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        log.trace("[activate] entered activate method.");
        Dictionary props = ctx.getProperties();
        this.topics = PropertiesUtil.toStringArray(props.get(OSGI_TOPICS));
        this.filter = PropertiesUtil.toString(props.get(OSGI_FILTER), (String)"").trim();
        this.category = PropertiesUtil.toString(props.get(OSGI_CATEGORY), (String)"").trim();
        this.level = PropertiesUtil.toString(props.get(OSGI_LEVEL), (String)DEFAULT_LEVEL);
        this.logLevel = LogLevel.fromProperty(this.level);
        boolean bl = this.valid = this.topics != null && this.topics.length > 0 && !this.category.isEmpty();
        if (this.valid) {
            this.eventLogger = LoggerFactory.getLogger((String)this.category);
            Hashtable<String, Object> registrationProps = new Hashtable<String, Object>();
            ((Dictionary)registrationProps).put(OSGI_TOPICS, this.topics);
            if (!this.filter.isEmpty()) {
                ((Dictionary)registrationProps).put(OSGI_FILTER, this.filter);
            }
            this.registration = ctx.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, registrationProps);
        } else {
            log.warn("Not registering invalid event handler. Check configuration.");
        }
        log.debug("[activate] logger state: {}", (Object)this);
    }

    @Deactivate
    protected void deactivate() {
        log.trace("[deactivate] entered deactivate method.");
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.eventLogger = null;
        this.logLevel = null;
    }

    public String toString() {
        return "EventLogger{valid=" + this.valid + ", topics=" + Arrays.toString(this.topics) + ", filter='" + this.filter + '\'' + ", category='" + this.category + '\'' + ", level='" + this.level + '\'' + ", enabled=" + this.isLoggerEnabled() + '}';
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;


        public static LogLevel fromProperty(String prop) {
            if (prop != null) {
                for (LogLevel value : LogLevel.values()) {
                    if (!value.name().equalsIgnoreCase(prop)) continue;
                    return value;
                }
            }
            return null;
        }
    }
}

