/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.oak.impl;

import com.adobe.acs.commons.oak.EnsureOakIndexManager;
import com.adobe.acs.commons.oak.impl.AppliableEnsureOakIndex;
import com.adobe.acs.commons.oak.impl.EnsureOakIndexManagerMBean;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Properties(value={@Property(name="felix.webconsole.title", value={"Ensure Oak Index"}), @Property(name="felix.webconsole.label", value={"ensureOakIndex"}), @Property(name="felix.webconsole.category", value={"Sling"}), @Property(name="jmx.objectname", value={"com.adobe.acs.oak:type=Ensure Oak Index"}, propertyPrivate=true)})
@Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface=AppliableEnsureOakIndex.class, policy=ReferencePolicy.DYNAMIC)
@Service(value={DynamicMBean.class, EnsureOakIndexManager.class})
public class EnsureOakIndexManagerImpl
extends AnnotatedStandardMBean
implements EnsureOakIndexManager,
EnsureOakIndexManagerMBean {
    private static final Logger log = LoggerFactory.getLogger(EnsureOakIndexManagerImpl.class);
    private CopyOnWriteArrayList<AppliableEnsureOakIndex> ensureIndexes = new CopyOnWriteArrayList();

    public EnsureOakIndexManagerImpl() throws NotCompliantMBeanException {
        super(EnsureOakIndexManagerMBean.class);
    }

    @Override
    public final int ensureAll(boolean force) {
        log.info("Applying all un-applied ensure index definitions");
        int count = 0;
        for (AppliableEnsureOakIndex index : this.ensureIndexes) {
            if (index.isApplied() && !force) continue;
            index.apply();
            ++count;
            log.debug("Started applying index definition on {}", (Object)index);
        }
        return count;
    }

    @Override
    public final int ensure(boolean force, String ensureDefinitionPath) {
        int count = 0;
        for (AppliableEnsureOakIndex index : this.ensureIndexes) {
            if (index.isApplied() && !force || !StringUtils.equals((String)ensureDefinitionPath, (String)index.getEnsureDefinitionsPath())) continue;
            index.apply();
            ++count;
            log.debug("Started async job applying index definition for {}", (Object)index);
        }
        return count;
    }

    protected final void bindAppliableEnsureOakIndex(AppliableEnsureOakIndex index) {
        if (index != null && !this.ensureIndexes.contains(index)) {
            this.ensureIndexes.add(index);
        }
    }

    protected final void unbindAppliableEnsureOakIndex(AppliableEnsureOakIndex index) {
        if (index != null && this.ensureIndexes.contains(index)) {
            this.ensureIndexes.remove(index);
        }
    }

    @Override
    public final TabularData getEnsureOakIndexes() throws OpenDataException {
        CompositeType configType = new CompositeType("Ensure Oak Index Configurations", "Ensure Oak Index Configurations", new String[]{"Ensure Definitions Path", "Oak Indexes Path", "Applied", "Immediate"}, new String[]{"Ensure Definitions Path", "Oak Indexes Path", "Applied", "Immediate"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Ensure Oak Index Configuration", "Ensure Oak Index Configuration", configType, new String[]{"Ensure Definitions Path", "Oak Indexes Path"}));
        for (AppliableEnsureOakIndex index : this.ensureIndexes) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Ensure Definitions Path", index.getEnsureDefinitionsPath());
            data.put("Oak Indexes Path", index.getOakIndexesPath());
            data.put("Applied", index.isApplied());
            data.put("Immediate", index.isImmediate());
            tabularData.put(new CompositeDataSupport(configType, data));
        }
        return tabularData;
    }
}

