/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packaging.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.adobe.acs.commons.packaging.impl.AbstractPackagerServlet;
import com.adobe.acs.commons.util.AemCapabilityHelper;
import com.day.jcr.vault.fs.api.Filter;
import com.day.jcr.vault.fs.api.PathFilterSet;
import com.day.jcr.vault.fs.filter.DefaultPathFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/packager/acl-packager"}, selectors={"package"}, extensions={"json"})
public class ACLPackagerServletImpl
extends AbstractPackagerServlet {
    private static final String INCLUDE_PATTERNS = "includePatterns";
    private static final String PRINCIPAL_NAMES = "principalNames";
    private static final String INCLUDE_PRINCIPALS = "includePrincipals";
    private static final String DEFAULT_PACKAGE_NAME = "acls";
    private static final String DEFAULT_PACKAGE_GROUP_NAME = "ACLs";
    private static final String DEFAULT_PACKAGE_VERSION = "1.0.0";
    private static final String DEFAULT_PACKAGE_DESCRIPTION = "ACL Package initially defined by a ACS AEM Commons - ACL Packager configuration.";
    private static final boolean DEFAULT_INCLUDE_PRINCIPALS = false;
    private static final String QUERY_LANG = "JCR-SQL2";
    private static final String CQ5_QUERY = "SELECT * FROM [rep:ACL]";
    private static final String[] CQ5_QUERIES = new String[]{"SELECT * FROM [rep:ACL]"};
    private static final String AEM6_QUERY_ACE = "SELECT * FROM [rep:ACE] where [rep:principalName] is not null";
    private static final String[] AEM6_QUERIES = new String[]{"SELECT * FROM [rep:ACE] where [rep:principalName] is not null"};
    private static final String ACL_PACKAGE_THUMBNAIL_RESOURCE_PATH = "/apps/acs-commons/components/utilities/packager/acl-packager/definition/package-thumbnail.png";
    @Reference
    private PackageHelper packageHelper;
    @Reference
    private AemCapabilityHelper aemCapabilityHelper;
    private static Comparator<Resource> resourceComparator = new Comparator<Resource>(){

        @Override
        public int compare(Resource r1, Resource r2) {
            return r1.getPath().compareTo(r2.getPath());
        }
    };

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        boolean preview = Boolean.parseBoolean(request.getParameter("preview"));
        this.log.trace("Preview mode: {}", (Object)preview);
        ValueMap properties = this.getProperties(request);
        String[] principalNames = (String[])properties.get(PRINCIPAL_NAMES, (Object)new String[0]);
        List<PathFilterSet> packageResources = this.findResources(resourceResolver, Arrays.asList(principalNames), this.toPatterns(Arrays.asList((Object[])properties.get(INCLUDE_PATTERNS, (Object)new String[0]))));
        try {
            if (((Boolean)properties.get(INCLUDE_PRINCIPALS, (Object)false)).booleanValue()) {
                packageResources.addAll(this.getPrincipalResources(resourceResolver, principalNames));
            }
            this.doPackaging(request, response, preview, properties, packageResources);
        }
        catch (RepositoryException ex) {
            this.log.error(ex.getMessage());
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
        catch (IOException ex) {
            this.log.error(ex.getMessage());
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
        catch (JSONException ex) {
            this.log.error(ex.getMessage());
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
    }

    private ValueMap getProperties(SlingHttpServletRequest request) {
        if (request.getResource().getChild("configuration") == null) {
            this.log.warn("ACL Packager Configuration node could not be found for: {}", (Object)request.getResource());
            return new ValueMapDecorator(new HashMap());
        }
        return (ValueMap)request.getResource().getChild("configuration").adaptTo(ValueMap.class);
    }

    private List<PathFilterSet> findResources(ResourceResolver resourceResolver, List<String> principalNames, List<Pattern> includePatterns) {
        boolean isOak = true;
        try {
            isOak = this.aemCapabilityHelper.isOak();
        }
        catch (RepositoryException e) {
            isOak = true;
        }
        TreeSet<Resource> resources = new TreeSet<Resource>(resourceComparator);
        ArrayList<PathFilterSet> pathFilterSets = new ArrayList<PathFilterSet>();
        String[] queries = CQ5_QUERIES;
        if (isOak) {
            queries = AEM6_QUERIES;
        }
        for (String query : queries) {
            Iterator hits = resourceResolver.findResources(query, QUERY_LANG);
            block3: while (hits.hasNext()) {
                Resource hit = (Resource)hits.next();
                Resource repPolicy = null;
                if (isOak) {
                    if (hit.getParent() != null) {
                        repPolicy = hit.getParent();
                    }
                } else {
                    repPolicy = hit;
                }
                if (!this.isIncluded(repPolicy, includePatterns)) continue;
                this.log.debug("Included by pattern [ {} ]", (Object)repPolicy.getPath());
                Iterator aces = repPolicy.listChildren();
                while (aces.hasNext()) {
                    Resource ace = (Resource)aces.next();
                    ValueMap props = (ValueMap)ace.adaptTo(ValueMap.class);
                    String repPrincipalName = (String)props.get("rep:principalName", String.class);
                    if (principalNames != null && !principalNames.isEmpty() && !principalNames.contains(repPrincipalName)) continue;
                    resources.add(repPolicy);
                    this.log.debug("Included by principal [ {} ]", (Object)repPolicy.getPath());
                    continue block3;
                }
            }
        }
        for (Resource resource : resources) {
            pathFilterSets.add(new PathFilterSet(resource.getPath()));
        }
        this.log.debug("Found {} matching rep:policy resources.", (Object)pathFilterSets.size());
        return pathFilterSets;
    }

    private List<PathFilterSet> getPrincipalResources(ResourceResolver resourceResolver, String[] principalNames) throws RepositoryException {
        UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
        ArrayList<PathFilterSet> pathFilterSets = new ArrayList<PathFilterSet>();
        for (String principalName : principalNames) {
            Resource resource;
            Authorizable authorizable = userManager.getAuthorizable(principalName);
            if (authorizable == null || (resource = resourceResolver.getResource(authorizable.getPath())) == null) continue;
            PathFilterSet principal = new PathFilterSet(resource.getPath());
            principal.addExclude((Filter)new DefaultPathFilter(resource.getPath() + "/\\.tokens"));
            pathFilterSets.add(principal);
        }
        return pathFilterSets;
    }

    @Override
    protected String getPackageThumbnailPath() {
        return ACL_PACKAGE_THUMBNAIL_RESOURCE_PATH;
    }

    @Override
    protected String getDefaultPackageDescription() {
        return DEFAULT_PACKAGE_DESCRIPTION;
    }

    @Override
    protected String getDefaultPackageGroupName() {
        return DEFAULT_PACKAGE_GROUP_NAME;
    }

    @Override
    protected String getDefaultPackageName() {
        return DEFAULT_PACKAGE_NAME;
    }

    @Override
    protected PackageHelper getPackageHelper() {
        return this.packageHelper;
    }

    private boolean isIncluded(Resource resource, List<Pattern> includePatterns) {
        if (resource == null) {
            return false;
        }
        if (!resource.isResourceType("rep:ACL")) {
            return false;
        }
        if (includePatterns == null || includePatterns.isEmpty()) {
            return true;
        }
        for (Pattern pattern : includePatterns) {
            Matcher matcher = pattern.matcher(resource.getPath());
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private List<Pattern> toPatterns(List<String> data) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String item : data) {
            patterns.add(Pattern.compile(item));
        }
        if (this.log.isDebugEnabled()) {
            for (Pattern pattern : patterns) {
                this.log.debug("Compiled pattern: {}", (Object)pattern.toString());
            }
        }
        return patterns;
    }

    protected void bindPackageHelper(PackageHelper packageHelper) {
        this.packageHelper = packageHelper;
    }

    protected void unbindPackageHelper(PackageHelper packageHelper) {
        if (this.packageHelper == packageHelper) {
            this.packageHelper = null;
        }
    }

    protected void bindAemCapabilityHelper(AemCapabilityHelper aemCapabilityHelper) {
        this.aemCapabilityHelper = aemCapabilityHelper;
    }

    protected void unbindAemCapabilityHelper(AemCapabilityHelper aemCapabilityHelper) {
        if (this.aemCapabilityHelper == aemCapabilityHelper) {
            this.aemCapabilityHelper = null;
        }
    }
}

