/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packaging.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.jcr.vault.fs.api.PathFilterSet;
import com.day.jcr.vault.fs.io.AccessControlHandling;
import com.day.jcr.vault.packaging.JcrPackage;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPackagerServlet
extends SlingAllMethodsServlet {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PACKAGE_NAME = "packageName";
    private static final String PACKAGE_GROUP_NAME = "packageGroupName";
    private static final String PACKAGE_VERSION = "packageVersion";
    private static final String PACKAGE_DESCRIPTION = "packageDescription";
    private static final String PACKAGE_ACL_HANDLING = "packageACLHandling";
    private static final String CONFLICT_RESOLUTION = "conflictResolution";
    private static final String INCLUDE_CONFIGURATION = "includeConfiguration";
    private static final String DEFAULT_PACKAGE_VERSION = "1.0.0";
    private static final boolean DEFAULT_INCLUDE_CONFIGURATION = false;

    protected PathFilterSet getPackagerPageResource(SlingHttpServletRequest request) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(request.getResource());
        if (page != null) {
            return new PathFilterSet(page.getPath());
        }
        return null;
    }

    protected void doPackaging(SlingHttpServletRequest request, SlingHttpServletResponse response, boolean preview, ValueMap properties, List<PathFilterSet> packageResources) throws IOException, JSONException, RepositoryException {
        PathFilterSet tmp;
        if (((Boolean)properties.get(INCLUDE_CONFIGURATION, (Object)false)).booleanValue() && (tmp = this.getPackagerPageResource(request)) != null) {
            packageResources.add(tmp);
        }
        HashMap<String, String> packageDefinitionProperties = new HashMap<String, String>();
        packageDefinitionProperties.put("acHandling", (String)properties.get(PACKAGE_ACL_HANDLING, (Object)AccessControlHandling.OVERWRITE.toString()));
        packageDefinitionProperties.put("jcr:description", (String)properties.get(PACKAGE_DESCRIPTION, (Object)this.getDefaultPackageDescription()));
        if (preview) {
            response.getWriter().print(this.getPackageHelper().getPathFilterSetPreviewJSON(packageResources));
        } else if (packageResources == null || packageResources.isEmpty()) {
            response.getWriter().print(this.getPackageHelper().getErrorJSON("Refusing to create a package with no filter set rules."));
        } else {
            JcrPackage jcrPackage = this.getPackageHelper().createPackageFromPathFilterSets(packageResources, (Session)request.getResourceResolver().adaptTo(Session.class), (String)properties.get(PACKAGE_GROUP_NAME, (Object)this.getDefaultPackageGroupName()), (String)properties.get(PACKAGE_NAME, (Object)this.getDefaultPackageName()), (String)properties.get(PACKAGE_VERSION, (Object)DEFAULT_PACKAGE_VERSION), PackageHelper.ConflictResolution.valueOf((String)properties.get(CONFLICT_RESOLUTION, (Object)PackageHelper.ConflictResolution.IncrementVersion.toString())), packageDefinitionProperties);
            String thumbnailPath = this.getPackageThumbnailPath();
            if (thumbnailPath != null) {
                this.getPackageHelper().addThumbnail(jcrPackage, request.getResourceResolver().getResource(thumbnailPath));
            }
            this.log.debug("Successfully created JCR package");
            response.getWriter().print(this.getPackageHelper().getSuccessJSON(jcrPackage));
        }
    }

    protected abstract String getDefaultPackageDescription();

    protected abstract String getDefaultPackageGroupName();

    protected abstract String getDefaultPackageName();

    protected abstract String getPackageThumbnailPath();

    protected abstract PackageHelper getPackageHelper();
}

