/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.impl;

import com.adobe.acs.commons.quickly.QuicklyEngine;
import com.adobe.acs.commons.util.BufferingResponse;
import com.adobe.acs.commons.util.ResourceDataUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;

@Component(policy=ConfigurationPolicy.OPTIONAL)
@Property(name="pattern", value={".*"})
@Service
public class QuicklyFilter
implements Filter {
    private static final String[] REJECT_PATH_PREFIXES = new String[]{"/libs/granite/core/content/login"};
    private static final String HTML_FILE = "/apps/acs-commons/components/utilities/quickly/inject.html";
    private static String appHTML = "";
    @Reference
    private QuicklyEngine quicklyEngine;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        int bodyIndex;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.accepts(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        BufferingResponse capturedResponse = new BufferingResponse(response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)capturedResponse);
        String contents = capturedResponse.getContents();
        if (contents != null && StringUtils.contains((String)response.getContentType(), (String)"html") && (bodyIndex = contents.indexOf("</body>")) != -1) {
            PrintWriter printWriter = response.getWriter();
            printWriter.write(contents.substring(0, bodyIndex));
            printWriter.write(appHTML);
            printWriter.write(contents.substring(bodyIndex));
            return;
        }
        if (contents != null) {
            response.getWriter().write(contents);
        }
    }

    public void destroy() {
    }

    private boolean accepts(HttpServletRequest request) {
        if (!StringUtils.equalsIgnoreCase((String)"get", (String)request.getMethod())) {
            return false;
        }
        if (StringUtils.startsWithAny((String)request.getRequestURI(), (String[])REJECT_PATH_PREFIXES)) {
            return false;
        }
        if (StringUtils.equals((String)request.getHeader("X-Requested-With"), (String)"XMLHttpRequest")) {
            return false;
        }
        if (StringUtils.endsWith((String)request.getHeader("Referer"), (String)("/editor.html" + request.getRequestURI()))) {
            return false;
        }
        return !StringUtils.endsWith((String)request.getHeader("Referer"), (String)"/cf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected final void activate(Map<String, String> config) throws IOException, RepositoryException, LoginException {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            appHTML = ResourceDataUtil.getNTFileAsString(HTML_FILE, resourceResolver);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    protected void bindQuicklyEngine(QuicklyEngine quicklyEngine) {
        this.quicklyEngine = quicklyEngine;
    }

    protected void unbindQuicklyEngine(QuicklyEngine quicklyEngine) {
        if (this.quicklyEngine == quicklyEngine) {
            this.quicklyEngine = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

