/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.status.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.adobe.acs.commons.replication.status.ReplicationStatusManager;
import com.day.cq.jcrclustersupport.ClusterAware;
import com.day.jcr.vault.packaging.JcrPackage;
import com.day.jcr.vault.packaging.PackageException;
import com.day.jcr.vault.packaging.Packaging;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Package Replication Status Updater", description="Event handler that listens for Jcr Package replications and updates the Replication Status of its content accordingly.", metatype=true, immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(label="Event Topics", value={"com/day/cq/replication"}, description="[Required] Event Topics this event handler will to respond to.", name="event.topics", propertyPrivate=true), @Property(label="Event Filters", value={"(type=ACTIVATE)"}, name="event.filter", propertyPrivate=true), @Property(name="job.topics", value={"acs-commons/replication/package"})})
@Service
public class JcrPackageReplicationStatusEventHandler
implements JobConsumer,
EventHandler,
ClusterAware {
    private static final String PROPERTY_PATHS = "paths";
    private static final Logger log = LoggerFactory.getLogger(JcrPackageReplicationStatusEventHandler.class);
    private static final String[] DEFAULT_REPLICATION_STATUS_NODE_TYPES = new String[]{"cq:ReplicationStatus", "cq:Page/cq:PageContent", "dam:AssetContent", "rep:User", "rep:Group", "sling:OrderedFolder/nt:unstructured"};
    private String[] replicationStatusNodeTypes = DEFAULT_REPLICATION_STATUS_NODE_TYPES;
    @Property(label="Replication Status Types", description="Node types that are candidates to update Replication Status on", cardinality=0x7FFFFFFF, value={"cq:ReplicationStatus", "cq:PageContent", "dam:AssetContent", "rep:User", "rep:Group", "sling:OrderedFolder/nt:unstructured"})
    public static final String PROP_REPLICATION_STATUS_NODE_TYPES = "node-types";
    protected static final String JOB_TOPIC = "acs-commons/replication/package";
    @Reference
    private Packaging packaging;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ReplicationStatusManager replicationStatusManager;
    @Reference
    private PackageHelper packageHelper;
    @Reference
    private JobManager jobManager;
    private ResourceResolver adminResourceResolver;
    private boolean isMaster = false;
    private static final String DEFAULT_REPLICATED_BY = "Package Replication";
    private String replicatedBy = "Package Replication";
    @Property(label="Replicated By", description="The 'name' to set the 'replicated by' property to. Defaults to: Package Replication", value={"Package Replication"})
    public static final String PROP_REPLICATED_BY = "replicated-by";
    private static final ReplicatedAt DEFAULT_REPLICATED_AT = ReplicatedAt.PACKAGE_LAST_MODIFIED;
    private ReplicatedAt replicatedAt = DEFAULT_REPLICATED_AT;
    @Property(label="Replicated At", description="The 'value' used to set the 'replicated at' property. [ Default: Package Last Modified ]", options={@PropertyOption(name="PACKAGE_LAST_MODIFIED", value="Package Last Modified"), @PropertyOption(name="CURRENT_TIME", value="Current Time")})
    public static final String PROP_REPLICATED_AT = "replicated-at";

    public final void handleEvent(Event event) {
        String[] paths;
        if (this.isMaster && this.containsJcrPackagePath(paths = (String[])event.getProperty(PROPERTY_PATHS)) && !CollectionUtils.isEmpty(this.getJcrPackages(paths))) {
            this.jobManager.addJob(JOB_TOPIC, Collections.singletonMap(PROPERTY_PATHS, paths));
        }
    }

    public final JobConsumer.JobResult process(Job job) {
        Object[] paths = (String[])job.getProperty(PROPERTY_PATHS);
        log.debug("Processing Replication Status Update for JCR Package: {}", paths);
        List<JcrPackage> jcrPackages = this.getJcrPackages((String[])paths);
        if (CollectionUtils.isEmpty(jcrPackages)) {
            log.warn("JCR Package is unavailable for Replication Status Update at: {}", paths);
            return JobConsumer.JobResult.OK;
        }
        for (JcrPackage jcrPackage : jcrPackages) {
            try {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                for (String packagePath : this.packageHelper.getContents(jcrPackage)) {
                    Resource resource = this.adminResourceResolver.getResource(packagePath);
                    if (!this.accept(resource)) continue;
                    resources.add(resource);
                }
                if (resources.size() > 0) {
                    this.replicationStatusManager.setReplicationStatus(this.adminResourceResolver, this.replicatedBy, this.getJcrPackageLastModified(this.adminResourceResolver, jcrPackage), ReplicationStatusManager.Status.ACTIVATED, resources.toArray(new Resource[resources.size()]));
                    log.info("Updated Replication Status for JCR Package: {}", (Object)jcrPackage.getDefinition().getId());
                    continue;
                }
                log.info("Could not find any resources in JCR Package [ {} ] that are candidates to have their Replication Status updated", (Object)jcrPackage.getDefinition().getId());
            }
            catch (RepositoryException e) {
                log.error("RepositoryException occurred updating replication status for contents of package");
                log.error(e.getMessage());
            }
            catch (IOException e) {
                log.error("IOException occurred updating replication status for contents of package");
                log.error(e.getMessage());
            }
            catch (PackageException e) {
                log.error("Could not retrieve the Packages contents.");
                log.error(e.getMessage());
            }
        }
        return JobConsumer.JobResult.OK;
    }

    private boolean containsJcrPackagePath(String[] paths) {
        for (String path : paths) {
            if (!StringUtils.startsWith((String)path, (String)"/etc/packages/") || !StringUtils.endsWith((String)path, (String)".zip")) continue;
            return true;
        }
        return false;
    }

    private List<JcrPackage> getJcrPackages(String[] paths) {
        ArrayList<JcrPackage> packages = new ArrayList<JcrPackage>();
        for (String path : paths) {
            Resource eventResource = this.adminResourceResolver.getResource(path);
            try {
                JcrPackage jcrPackage = this.packaging.open((Node)eventResource.adaptTo(Node.class), false);
                if (jcrPackage == null) continue;
                packages.add(jcrPackage);
            }
            catch (RepositoryException e) {
                log.warn("Error checking if the path [ {} ] is a JCR Package.", (Object)path);
            }
        }
        return packages;
    }

    private boolean accept(Resource resource) throws RepositoryException {
        if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource)) {
            return false;
        }
        for (String nodeTypes : this.replicationStatusNodeTypes) {
            String[] hierarchyNodeTypes = StringUtils.split((String)nodeTypes, (String)"/");
            boolean match = true;
            Resource walkingResource = resource;
            for (int i = hierarchyNodeTypes.length - 1; i >= 0; --i) {
                if (walkingResource == null) {
                    match = false;
                    break;
                }
                Node node = (Node)walkingResource.adaptTo(Node.class);
                if (node == null || !node.isNodeType(hierarchyNodeTypes[i])) {
                    match = false;
                    break;
                }
                walkingResource = walkingResource.getParent();
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private Calendar getJcrPackageLastModified(ResourceResolver resourceResolver, JcrPackage jcrPackage) throws RepositoryException {
        if (ReplicatedAt.CURRENT_TIME.equals((Object)this.replicatedAt)) {
            return Calendar.getInstance();
        }
        String path = jcrPackage.getNode().getPath();
        Resource resource = resourceResolver.getResource(path).getChild("jcr:content");
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        return (Calendar)properties.get("jcr:lastModified", Calendar.class);
    }

    @Activate
    private void activate(Map<String, String> config) throws LoginException {
        log.trace("Activating the ACS AEM Commons - JCR Package Replication Status Updater (Event Handler)");
        this.adminResourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
        this.replicatedBy = PropertiesUtil.toString((Object)config.get(PROP_REPLICATED_BY), (String)DEFAULT_REPLICATED_BY);
        String tmp = PropertiesUtil.toString((Object)config.get(PROP_REPLICATED_AT), (String)"");
        try {
            this.replicatedAt = ReplicatedAt.valueOf(tmp);
        }
        catch (IllegalArgumentException ex) {
            this.replicatedAt = ReplicatedAt.PACKAGE_LAST_MODIFIED;
        }
        this.replicationStatusNodeTypes = PropertiesUtil.toStringArray((Object)config.get(PROP_REPLICATION_STATUS_NODE_TYPES), (String[])DEFAULT_REPLICATION_STATUS_NODE_TYPES);
        log.info("Package Replication Status - Replicated By: [ {} ]", (Object)this.replicatedBy);
        log.info("Package Replication Status - Replicated At: [ {} ]", (Object)this.replicatedAt.toString());
        log.info("Package Replication Status - Node Types: [ {} ]", (Object)StringUtils.join((Object[])this.replicationStatusNodeTypes, (String)", "));
    }

    @Deactivate
    private void deactivate(Map<String, String> properties) {
        if (this.adminResourceResolver != null) {
            this.adminResourceResolver.close();
        }
    }

    public final void bindRepository(String repositoryId, String clusterId, boolean newIsMaster) {
        this.isMaster = newIsMaster;
    }

    public final void unbindRepository() {
        this.isMaster = false;
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindReplicationStatusManager(ReplicationStatusManager replicationStatusManager) {
        this.replicationStatusManager = replicationStatusManager;
    }

    protected void unbindReplicationStatusManager(ReplicationStatusManager replicationStatusManager) {
        if (this.replicationStatusManager == replicationStatusManager) {
            this.replicationStatusManager = null;
        }
    }

    protected void bindPackageHelper(PackageHelper packageHelper) {
        this.packageHelper = packageHelper;
    }

    protected void unbindPackageHelper(PackageHelper packageHelper) {
        if (this.packageHelper == packageHelper) {
            this.packageHelper = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    private static enum ReplicatedAt {
        CURRENT_TIME,
        PACKAGE_LAST_MODIFIED;

    }
}

