/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.rewriter.impl;

import com.adobe.acs.commons.rewriter.AbstractTransformer;
import com.adobe.acs.commons.rewriter.impl.VersionedClientLibraryMd5CacheKey;
import com.adobe.acs.commons.util.impl.AbstractGuavaCacheMBean;
import com.adobe.acs.commons.util.impl.GenericCacheMBean;
import com.adobe.granite.ui.clientlibs.HtmlLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Component(metatype=true, label="Versioned Clientlibs Transformer Factory", description="Sling Rewriter Transformer Factory to add auto-generated checksums to client library references")
@Properties(value={@Property(name="pipeline.type", value={"versioned-clientlibs"}, propertyPrivate=true), @Property(name="event.topics", value={"com/adobe/granite/ui/librarymanager/INVALIDATED"}, propertyPrivate=true), @Property(name="jmx.objectname", value={"com.adobe.acs.commons.rewriter:type=VersionedClientlibsTransformerMd5Cache"}, propertyPrivate=true)})
@Service(value={DynamicMBean.class, TransformerFactory.class, EventHandler.class})
public final class VersionedClientlibsTransformerFactory
extends AbstractGuavaCacheMBean<VersionedClientLibraryMd5CacheKey, String>
implements TransformerFactory,
EventHandler,
GenericCacheMBean {
    private static final Logger log = LoggerFactory.getLogger(VersionedClientlibsTransformerFactory.class);
    private static final int DEFAULT_MD5_CACHE_SIZE = 300;
    private static final boolean DEFAULT_DISABLE_VERSIONING = false;
    @Property(label="MD5 Cache Size", description="Maximum size of the md5 cache.", intValue={300})
    private static final String PROP_MD5_CACHE_SIZE = "md5cache.size";
    @Property(label="Disable Versioning", description="Should versioning of clientlibs be disabled", boolValue={false})
    private static final String PROP_DISABLE_VERSIONING = "disable.versioning";
    private static final String ATTR_JS_PATH = "src";
    private static final String ATTR_CSS_PATH = "href";
    private static final String CSS_TYPE = "text/css";
    private static final String JS_TYPE = "text/javascript";
    private static final String MIN_SELECTOR = "min";
    private static final String MIN_SELECTOR_SEGMENT = ".min";
    private Cache<VersionedClientLibraryMd5CacheKey, String> md5Cache;
    private boolean disableVersioning;
    @Reference
    private HtmlLibraryManager htmlLibraryManager;

    public VersionedClientlibsTransformerFactory() throws NotCompliantMBeanException {
        super(GenericCacheMBean.class);
    }

    @Activate
    protected void activate(Map<String, Object> props) {
        int size = PropertiesUtil.toInteger((Object)props.get(PROP_MD5_CACHE_SIZE), (int)300);
        this.md5Cache = CacheBuilder.newBuilder().recordStats().maximumSize((long)size).build();
        this.disableVersioning = PropertiesUtil.toBoolean((Object)props.get(PROP_DISABLE_VERSIONING), (boolean)false);
    }

    @Deactivate
    protected void deactivate() {
        this.md5Cache = null;
    }

    public Transformer createTransformer() {
        return new VersionableClientlibsTransformer();
    }

    private Attributes versionClientLibs(String elementName, Attributes attrs) {
        if (this.isCSS(elementName, attrs)) {
            return this.rebuildAttributes(new AttributesImpl(attrs), attrs.getIndex("", ATTR_CSS_PATH), attrs.getValue("", ATTR_CSS_PATH), LibraryType.CSS);
        }
        if (this.isJavaScript(elementName, attrs)) {
            return this.rebuildAttributes(new AttributesImpl(attrs), attrs.getIndex("", ATTR_JS_PATH), attrs.getValue("", ATTR_JS_PATH), LibraryType.JS);
        }
        return attrs;
    }

    private Attributes rebuildAttributes(AttributesImpl newAttributes, int index, String path, LibraryType libraryType) {
        String versionedPath = this.getVersionedPath(path, libraryType);
        if (StringUtils.isNotBlank((String)versionedPath)) {
            log.debug("Rewriting to: {}", (Object)versionedPath);
            newAttributes.setValue(index, versionedPath);
        } else {
            log.debug("Versioned Path could not be created properly");
        }
        return newAttributes;
    }

    private boolean isCSS(String elementName, Attributes attrs) {
        String rel = attrs.getValue("", "rel");
        String type = attrs.getValue("", "type");
        String href = attrs.getValue("", ATTR_CSS_PATH);
        return StringUtils.equals((String)"link", (String)elementName) && StringUtils.equals((String)rel, (String)"stylesheet") && StringUtils.equals((String)type, (String)CSS_TYPE) && StringUtils.startsWith((String)href, (String)"/") && !StringUtils.startsWith((String)href, (String)"//") && StringUtils.endsWith((String)href, (String)LibraryType.CSS.extension);
    }

    private boolean isJavaScript(String elementName, Attributes attrs) {
        String type = attrs.getValue("", "type");
        String src = attrs.getValue("", ATTR_JS_PATH);
        return StringUtils.equals((String)"script", (String)elementName) && StringUtils.equals((String)type, (String)JS_TYPE) && StringUtils.startsWith((String)src, (String)"/") && !StringUtils.startsWith((String)src, (String)"//") && StringUtils.endsWith((String)src, (String)LibraryType.JS.extension);
    }

    private String getVersionedPath(String originalPath, LibraryType libraryType) {
        try {
            HtmlLibrary htmlLibrary;
            boolean appendMinSelector = false;
            String libraryPath = StringUtils.substringBeforeLast((String)originalPath, (String)".");
            if (libraryPath.endsWith(MIN_SELECTOR_SEGMENT)) {
                appendMinSelector = true;
                libraryPath = StringUtils.substringBeforeLast((String)libraryPath, (String)".");
            }
            if ((htmlLibrary = this.htmlLibraryManager.getLibrary(libraryType, libraryPath)) != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(htmlLibrary.getLibraryPath());
                builder.append(".");
                if (appendMinSelector) {
                    builder.append(MIN_SELECTOR).append(".");
                }
                builder.append(this.getMd5(htmlLibrary));
                builder.append(libraryType.extension);
                return builder.toString();
            }
            log.debug("Could not find HtmlLibrary at path: {}", (Object)libraryPath);
            return null;
        }
        catch (Exception ex) {
            log.error("Attempting to get a versioned path for [ {} ] but could not because of: {}", (Object)originalPath, (Object)ex.getMessage());
            return originalPath;
        }
    }

    private String getMd5(final HtmlLibrary htmlLibrary) throws IOException, ExecutionException {
        return (String)this.md5Cache.get((Object)new VersionedClientLibraryMd5CacheKey(htmlLibrary), (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DigestUtils.md5Hex((InputStream)htmlLibrary.getInputStream());
            }
        });
    }

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        this.md5Cache.invalidate((Object)new VersionedClientLibraryMd5CacheKey(path, LibraryType.JS));
        this.md5Cache.invalidate((Object)new VersionedClientLibraryMd5CacheKey(path, LibraryType.CSS));
    }

    @Override
    protected Cache<VersionedClientLibraryMd5CacheKey, String> getCache() {
        return this.md5Cache;
    }

    @Override
    protected long getBytesLength(String cacheObj) {
        return cacheObj.getBytes().length;
    }

    @Override
    protected void addCacheData(Map<String, Object> data, String cacheObj) {
        data.put("Value", cacheObj);
    }

    @Override
    protected String toString(String cacheObj) throws Exception {
        return cacheObj;
    }

    @Override
    protected CompositeType getCacheEntryType() throws OpenDataException {
        return new CompositeType("Cache Entry", "Cache Entry", new String[]{"Cache Key", "Value"}, new String[]{"Cache Key", "Value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }

    private class VersionableClientlibsTransformer
    extends AbstractTransformer {
        private VersionableClientlibsTransformer() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            Attributes nextAttributes = VersionedClientlibsTransformerFactory.this.disableVersioning ? attrs : VersionedClientlibsTransformerFactory.this.versionClientLibs(localName, attrs);
            this.getContentHandler().startElement(namespaceURI, localName, qName, nextAttributes);
        }
    }
}

