/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.impl.GenericCacheMBean;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractGuavaCacheMBean<K, V>
extends AnnotatedStandardMBean
implements GenericCacheMBean {
    public <T> AbstractGuavaCacheMBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    protected AbstractGuavaCacheMBean(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
    }

    protected abstract Cache<K, V> getCache();

    protected abstract long getBytesLength(V var1);

    protected abstract void addCacheData(Map<String, Object> var1, V var2);

    protected abstract String toString(V var1) throws Exception;

    protected abstract CompositeType getCacheEntryType() throws OpenDataException;

    @Override
    public final void clearCache() {
        this.getCache().invalidateAll();
    }

    @Override
    public final long getCacheEntriesCount() {
        return this.getCache().size();
    }

    @Override
    public final String getCacheSize() {
        long size = 0L;
        ConcurrentMap cacheAsMap = this.getCache().asMap();
        for (Map.Entry entry : cacheAsMap.entrySet()) {
            size += this.getBytesLength(entry.getValue());
        }
        return FileUtils.byteCountToDisplaySize((long)size);
    }

    @Override
    public final TabularData getCacheStats() throws OpenDataException {
        CompositeType cacheEntryType = new CompositeType("Cache Stats", "Cache Stats", new String[]{"Stat", "Value"}, new String[]{"Stat", "Value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Cache Stats", "Cache Stats", cacheEntryType, new String[]{"Stat"}));
        CacheStats cacheStats = this.getCache().stats();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("Stat", "Request Count");
        row.put("Value", String.valueOf(cacheStats.requestCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Hit Count");
        row.put("Value", String.valueOf(cacheStats.hitCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Hit Rate");
        row.put("Value", String.format("%.0f%%", cacheStats.hitRate() * 100.0));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Miss Count");
        row.put("Value", String.valueOf(cacheStats.missCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Miss Rate");
        row.put("Value", String.format("%.0f%%", cacheStats.missRate() * 100.0));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Eviction Count");
        row.put("Value", String.valueOf(cacheStats.evictionCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Count");
        row.put("Value", String.valueOf(cacheStats.loadCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Exception Count");
        row.put("Value", String.valueOf(cacheStats.loadExceptionCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Exception Rate");
        row.put("Value", String.format("%.0f%%", cacheStats.loadExceptionRate() * 100.0));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Load Success Count");
        row.put("Value", String.valueOf(cacheStats.loadSuccessCount()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Average Load Penalty");
        row.put("Value", String.valueOf(cacheStats.averageLoadPenalty()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        row.put("Stat", "Total Load Time");
        row.put("Value", String.valueOf(cacheStats.totalLoadTime()));
        tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        return tabularData;
    }

    @Override
    public final TabularData getCacheContents() throws OpenDataException {
        CompositeType cacheEntryType = this.getCacheEntryType();
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType("Cache Entries", "Cache Entries", cacheEntryType, new String[]{"Cache Key"}));
        ConcurrentMap cacheAsMap = this.getCache().asMap();
        for (Map.Entry entry : cacheAsMap.entrySet()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Cache Key", entry.getKey().toString());
            Object cacheObj = entry.getValue();
            if (cacheObj != null) {
                this.addCacheData(data, cacheObj);
            }
            tabularData.put(new CompositeDataSupport(cacheEntryType, data));
        }
        return tabularData;
    }

    @Override
    public String getCacheEntry(String cacheKeyStr) throws Exception {
        Object persistenceObject;
        Object cacheKey = null;
        for (Object cacheKeyTmp : this.getCache().asMap().keySet()) {
            if (!StringUtils.equals((String)cacheKeyStr, (String)cacheKeyTmp.toString())) continue;
            cacheKey = cacheKeyTmp;
            break;
        }
        if (cacheKey != null && (persistenceObject = this.getCache().getIfPresent(cacheKey)) != null) {
            return this.toString(persistenceObject);
        }
        return "Invalid cache key parameter.";
    }
}

