/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class EvolutionConfig {
    private String[] ignoreProperties;
    private String[] ignoreResources;

    public EvolutionConfig(String[] ignoreProperties, String[] ignoreResources) {
        this.ignoreProperties = (String[])ArrayUtils.clone((Object[])ignoreProperties);
        this.ignoreResources = (String[])ArrayUtils.clone((Object[])ignoreResources);
    }

    public int getDepthForPath(String path) {
        return StringUtils.countMatches((String)StringUtils.substringAfterLast((String)path, (String)"jcr:frozenNode"), (String)"/");
    }

    public String getRelativePropertyName(String path) {
        return StringUtils.substringAfterLast((String)path, (String)"jcr:frozenNode").replaceFirst("/", "");
    }

    public String getRelativeResourceName(String path) {
        return StringUtils.substringAfterLast((String)path, (String)"jcr:frozenNode/");
    }

    public boolean handleProperty(String name) {
        for (String entry : this.ignoreProperties) {
            if (!Pattern.matches(entry, name)) continue;
            return false;
        }
        return true;
    }

    public boolean handleResource(String name) {
        for (String entry : this.ignoreResources) {
            if (!Pattern.matches(entry, name)) continue;
            return false;
        }
        return true;
    }

    public String printProperty(Property property) {
        try {
            return this.printObject(EvolutionConfig.toJavaObject(property));
        }
        catch (RepositoryException e1) {
            return e1.getMessage();
        }
    }

    public String printObject(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            StringBuilder result = new StringBuilder();
            result.append("[");
            for (int i = 0; i < values.length; ++i) {
                result.append(values[i]);
                if (i == values.length - 1) continue;
                result.append(", ");
            }
            result.append("]");
            return result.toString();
        }
        if (obj instanceof Calendar) {
            Calendar value = (Calendar)obj;
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateFormat.format(value.getTime());
        }
        return obj.toString();
    }

    private static Object toJavaObject(Property property) throws RepositoryException {
        if (property.isMultiple()) {
            Object firstValue;
            Value[] values = property.getValues();
            Object object = firstValue = values.length > 0 ? EvolutionConfig.toJavaObject(values[0]) : null;
            Object[] result = firstValue instanceof Boolean ? new Boolean[values.length] : (firstValue instanceof Calendar ? new Calendar[values.length] : (firstValue instanceof Double ? new Double[values.length] : (firstValue instanceof Long ? new Long[values.length] : (firstValue instanceof BigDecimal ? new BigDecimal[values.length] : (firstValue instanceof InputStream ? new Object[values.length] : new String[values.length])))));
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                if (value == null) continue;
                result[i] = EvolutionConfig.toJavaObject(value);
            }
            return result;
        }
        return EvolutionConfig.toJavaObject(property.getValue());
    }

    private static Object toJavaObject(Value value) throws RepositoryException {
        switch (value.getType()) {
            case 12: {
                return value.getDecimal();
            }
            case 2: {
                return new LazyInputStream(value);
            }
            case 6: {
                return value.getBoolean();
            }
            case 5: {
                return value.getDate();
            }
            case 4: {
                return value.getDouble();
            }
            case 3: {
                return value.getLong();
            }
        }
        return value.getString();
    }

    private static class LazyInputStream
    extends InputStream {
        private final Value value;
        private InputStream delegatee;

        public LazyInputStream(Value value) {
            this.value = value;
        }

        @Override
        public void close() throws IOException {
            if (this.delegatee != null) {
                this.delegatee.close();
            }
        }

        @Override
        public int available() throws IOException {
            return this.getStream().available();
        }

        @Override
        public int read() throws IOException {
            return this.getStream().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.getStream().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getStream().read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.getStream().skip(n);
        }

        @Override
        public boolean markSupported() {
            try {
                return this.getStream().markSupported();
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.getStream().mark(readlimit);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            this.getStream().reset();
        }

        private InputStream getStream() throws IOException {
            if (this.delegatee == null) {
                try {
                    this.delegatee = this.value.getBinary().getStream();
                }
                catch (RepositoryException re) {
                    throw (IOException)new IOException(re.getMessage()).initCause(re);
                }
            }
            return this.delegatee;
        }
    }
}

