/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.views.impl;

import com.adobe.acs.commons.util.ParameterUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.WCMUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(label="ACS AEM Commons - WCM Views Servlet", methods={"GET"}, resourceTypes={"cq/Page"}, selectors={"wcm-views"}, extensions={"json"}, metatype=true)
public class WCMViewsServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(WCMViewsServlet.class);
    private static final String[] DEFAULT_VIEWS = new String[0];
    private Map<String, String[]> defaultViews = new HashMap<String, String[]>();
    @Property(label="WCM Views by Path", description="Views to add to the Sidekick by default. Takes format [/path=view-1;view-2]", cardinality=0x7FFFFFFF, value={})
    public static final String PROP_DEFAULT_VIEWS = "wcm-views";

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        if (WCMMode.DISABLED.equals((Object)WCMMode.fromRequest((ServletRequest)request))) {
            response.setStatus(404);
            response.getWriter().write("");
            return;
        }
        PageManager pageManager = (PageManager)request.getResourceResolver().adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(request.getResource());
        WCMViewsResourceVisitor visitor = new WCMViewsResourceVisitor();
        visitor.accept(page.getContentResource());
        HashSet<String> viewSet = new HashSet<String>(visitor.getWCMViews());
        for (Map.Entry<String, String[]> entry : this.defaultViews.entrySet()) {
            if (!StringUtils.startsWith((String)page.getPath(), (String)entry.getKey())) continue;
            viewSet.addAll(Arrays.asList((Object[])entry.getValue()));
        }
        ArrayList<String> views = new ArrayList<String>(viewSet);
        Collections.sort(views);
        log.debug("Collected WCM Views {} for Page [ {} ]", views, (Object)page.getPath());
        JSONArray jsonArray = new JSONArray();
        for (String view : views) {
            JSONObject json = new JSONObject();
            try {
                json.put("title", (Object)(StringUtils.capitalize((String)view) + " View"));
                json.put("value", (Object)view);
                jsonArray.put((Object)json);
            }
            catch (JSONException e) {
                log.error("Unable to build WCM Views JSON output.", (Throwable)e);
            }
        }
        response.getWriter().write(jsonArray.toString());
    }

    @Activate
    protected final void activate(Map<String, String> config) {
        String[] tmp = PropertiesUtil.toStringArray((Object)config.get(PROP_DEFAULT_VIEWS), (String[])DEFAULT_VIEWS);
        this.defaultViews = ParameterUtil.toMap(tmp, "=", ";");
    }

    private static class WCMViewsResourceVisitor
    extends AbstractResourceVisitor {
        final Set<String> views = new TreeSet<String>();

        private WCMViewsResourceVisitor() {
        }

        public final List<String> getWCMViews() {
            return new ArrayList<String>(this.views);
        }

        protected void visit(Resource resource) {
            Object[] componentViews;
            Component component;
            ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
            Object[] resourceViews = (String[])properties.get("wcmViews", String[].class);
            if (ArrayUtils.isNotEmpty((Object[])resourceViews)) {
                this.views.addAll(Arrays.asList(resourceViews));
            }
            if ((component = WCMUtils.getComponent((Resource)resource)) != null && ArrayUtils.isNotEmpty((Object[])(componentViews = (String[])component.getProperties().get("wcmViews", String[].class)))) {
                this.views.addAll(Arrays.asList(componentViews));
            }
        }
    }
}

