/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public final class WorkflowRemovalStatus {
    String KEY_CHECKED_COUNT = "checkedCount";
    String KEY_COMPLETED_AT = "completedAt";
    String KEY_DURATION = "duration";
    String KEY_FORCE_QUIT_AT = "forceQuitAt";
    String KEY_ERRED_AT = "erredAt";
    String KEY_INITIATED_BY = "initiatedBy";
    String KEY_REMOVED_COUNT = "removedCount";
    String KEY_RUNNING = "running";
    String KEY_STARTED_AT = "startedAt";
    private static final String DATE_FORMAT = "yyyy/MM/dd 'at' hh:mm:ss a z";
    private static final long MS_IN_SECOND = 1000L;
    private boolean running = true;
    private String initiatedBy;
    private Calendar startedAt;
    private Calendar completedAt;
    private Calendar erredAt;
    private Calendar forceQuitAt;
    private int checked = 0;
    private int removed = 0;

    public WorkflowRemovalStatus(ResourceResolver resourceResolver) {
        this.initiatedBy = resourceResolver.getUserID();
        this.startedAt = Calendar.getInstance();
        this.completedAt = null;
        this.erredAt = null;
        this.checked = 0;
        this.removed = 0;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final void setRunning(boolean running) {
        this.running = running;
    }

    public final String getInitiatedBy() {
        return this.initiatedBy;
    }

    public final String getStartedAt() {
        if (this.startedAt == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(this.startedAt.getTime());
    }

    public Calendar getStartedAtCal() {
        return this.startedAt;
    }

    public final String getCompletedAt() {
        if (this.completedAt == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(this.completedAt.getTime());
    }

    public final void setCompletedAt(Calendar completedAt) {
        this.completedAt = completedAt;
    }

    public final int getChecked() {
        return this.checked;
    }

    public final void setChecked(int checked) {
        this.checked = checked;
    }

    public final int getRemoved() {
        return this.removed;
    }

    public final void setRemoved(int removed) {
        this.removed = removed;
    }

    public String getErredAt() {
        if (this.erredAt == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(this.erredAt.getTime());
    }

    public void setErredAt(Calendar erredAt) {
        this.erredAt = erredAt;
    }

    public void setForceQuitAt(Calendar forceQuitAt) {
        this.forceQuitAt = forceQuitAt;
    }

    public String getForceQuitAt() {
        if (this.forceQuitAt == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(this.forceQuitAt.getTime());
    }

    private long getDuration(Calendar start, Calendar end) {
        if (start == null || end == null) {
            return 0L;
        }
        if (end.before(start)) {
            return 0L;
        }
        return (end.getTimeInMillis() - start.getTimeInMillis()) / 1000L;
    }

    public JSONObject getJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put(this.KEY_RUNNING, this.isRunning());
        json.put(this.KEY_INITIATED_BY, (Object)this.getInitiatedBy());
        json.put(this.KEY_CHECKED_COUNT, this.getChecked());
        json.put(this.KEY_REMOVED_COUNT, this.getRemoved());
        if (this.getStartedAt() != null) {
            json.put(this.KEY_STARTED_AT, (Object)this.getStartedAt());
        }
        if (this.getErredAt() != null) {
            json.put(this.KEY_ERRED_AT, (Object)this.getErredAt());
            json.put(this.KEY_DURATION, this.getDuration(this.startedAt, this.erredAt));
        } else if (this.getForceQuitAt() != null) {
            json.put(this.KEY_FORCE_QUIT_AT, (Object)this.getForceQuitAt());
            json.put(this.KEY_DURATION, this.getDuration(this.startedAt, this.forceQuitAt));
        } else if (this.getCompletedAt() != null) {
            json.put(this.KEY_COMPLETED_AT, (Object)this.getCompletedAt());
            json.put(this.KEY_DURATION, this.getDuration(this.startedAt, this.completedAt));
        } else {
            json.put(this.KEY_DURATION, this.getDuration(this.startedAt, Calendar.getInstance()));
        }
        return json;
    }
}

