/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal.impl;

import com.adobe.acs.commons.workflow.bulk.removal.WorkflowInstanceRemover;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowRemovalException;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowRemovalForceQuitException;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowRemovalMaxDurationExceededException;
import com.adobe.acs.commons.workflow.bulk.removal.WorkflowRemovalStatus;
import com.adobe.acs.commons.workflow.bulk.removal.impl.WorkflowInstanceFolderComparator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public final class WorkflowInstanceRemoverImpl
implements WorkflowInstanceRemover {
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceRemoverImpl.class);
    private static final String WORKFLOW_FOLDER_FORMAT = "YYYY-MM-dd";
    private static final String PN_MODEL_ID = "modelId";
    private static final String PN_STARTED_AT = "startedAt";
    private static final String PN_STATUS = "status";
    private static final String PAYLOAD_PATH = "data/payload/path";
    private static final String NT_SLING_FOLDER = "sling:Folder";
    private static final String NT_CQ_WORKFLOW = "cq:Workflow";
    private static final Pattern NN_SERVER_FOLDER_PATTERN = Pattern.compile("server\\d+");
    private static final Pattern NN_DATE_FOLDER_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}.*");
    private static final int BATCH_SIZE = 1000;
    private static final int MAX_SAVE_RETRIES = 5;
    private static final long MS_IN_ONE_MINUTE = 60000L;
    private final AtomicReference<WorkflowRemovalStatus> status = new AtomicReference();
    private final AtomicBoolean forceQuit = new AtomicBoolean(false);

    @Override
    public WorkflowRemovalStatus getStatus() {
        return this.status.get();
    }

    @Override
    public void forceQuit() {
        this.forceQuit.set(true);
    }

    @Override
    public int removeWorkflowInstances(ResourceResolver resourceResolver, Collection<String> modelIds, Collection<String> statuses, Collection<Pattern> payloads, Calendar olderThan) throws PersistenceException, WorkflowRemovalException, InterruptedException, WorkflowRemovalForceQuitException {
        return this.removeWorkflowInstances(resourceResolver, modelIds, statuses, payloads, olderThan, 1000);
    }

    @Override
    public int removeWorkflowInstances(ResourceResolver resourceResolver, Collection<String> modelIds, Collection<String> statuses, Collection<Pattern> payloads, Calendar olderThan, int batchSize) throws PersistenceException, WorkflowRemovalException, InterruptedException, WorkflowRemovalForceQuitException {
        return this.removeWorkflowInstances(resourceResolver, modelIds, statuses, payloads, olderThan, batchSize, -1);
    }

    @Override
    public int removeWorkflowInstances(ResourceResolver resourceResolver, Collection<String> modelIds, Collection<String> statuses, Collection<Pattern> payloads, Calendar olderThan, int batchSize, int maxDurationInMins) throws PersistenceException, WorkflowRemovalException, InterruptedException, WorkflowRemovalForceQuitException {
        long start = System.currentTimeMillis();
        long end = -1L;
        int count = 0;
        int checkedCount = 0;
        int workflowRemovedCount = 0;
        if (maxDurationInMins > 0) {
            long maxDurationInMs = (long)maxDurationInMins * 60000L;
            end = start + maxDurationInMs;
        }
        try {
            this.start(resourceResolver);
            List<Resource> containerFolders = this.getWorkflowInstanceFolders(resourceResolver);
            for (Resource containerFolder : containerFolders) {
                log.debug("Checking [ {} ] for workflow instances to remove", (Object)containerFolder.getPath());
                Collection<Resource> sortedFolders = this.getSortedAndFilteredFolders(containerFolder);
                for (Resource folder : sortedFolders) {
                    int remaining = 0;
                    for (Resource instance : folder.getChildren()) {
                        if (this.forceQuit.get()) {
                            throw new WorkflowRemovalForceQuitException();
                        }
                        if (end > 0L && System.currentTimeMillis() >= end) {
                            throw new WorkflowRemovalMaxDurationExceededException();
                        }
                        ValueMap properties = instance.getValueMap();
                        if (!StringUtils.equals((String)NT_CQ_WORKFLOW, (String)((String)properties.get("jcr:primaryType", String.class)))) {
                            ++remaining;
                            continue;
                        }
                        ++checkedCount;
                        String status = (String)properties.get(PN_STATUS, String.class);
                        String model = (String)properties.get(PN_MODEL_ID, String.class);
                        Calendar startTime = (Calendar)properties.get(PN_STARTED_AT, Calendar.class);
                        String payload = (String)properties.get(PAYLOAD_PATH, String.class);
                        if (CollectionUtils.isNotEmpty(statuses) && !statuses.contains(status)) {
                            log.trace("Workflow instance [ {} ] has non-matching status of [ {} ]", (Object)instance.getPath(), (Object)status);
                            ++remaining;
                            continue;
                        }
                        if (CollectionUtils.isNotEmpty(modelIds) && !modelIds.contains(model)) {
                            log.trace("Workflow instance [ {} ] has non-matching model of [ {} ]", (Object)instance.getPath(), (Object)model);
                            ++remaining;
                            continue;
                        }
                        if (olderThan != null && startTime != null && startTime.before(olderThan)) {
                            log.trace("Workflow instance [ {} ] has non-matching start time of [ {} ]", (Object)instance.getPath(), (Object)startTime);
                            ++remaining;
                            continue;
                        }
                        if (CollectionUtils.isNotEmpty(payloads)) {
                            boolean match = false;
                            if (StringUtils.isNotEmpty((String)payload)) {
                                for (Pattern pattern : payloads) {
                                    if (!payload.matches(pattern.pattern())) continue;
                                    match = true;
                                    break;
                                }
                                if (!match) {
                                    log.trace("Workflow instance [ {} ] has non-matching payload path [ {} ]", (Object)instance.getPath(), (Object)payload);
                                    ++remaining;
                                    continue;
                                }
                            }
                        }
                        try {
                            ((Node)instance.adaptTo(Node.class)).remove();
                            log.debug("Removed workflow instance at [ {} ]", (Object)instance.getPath());
                            ++workflowRemovedCount;
                            ++count;
                        }
                        catch (RepositoryException e) {
                            log.error("Could not remove workflow instance at [ {} ]. Continuing...", (Object)instance.getPath(), (Object)e);
                        }
                        if (count % batchSize != 0) continue;
                        this.batchComplete(resourceResolver, checkedCount, workflowRemovedCount);
                        log.info("Removed a running total of [ {} ] workflow instances", (Object)count);
                    }
                    if (remaining != 0 || !this.isWorkflowDatedFolder(folder) || StringUtils.startsWith((String)folder.getName(), (String)new SimpleDateFormat(WORKFLOW_FOLDER_FORMAT).format(new Date()))) continue;
                    try {
                        ((Node)folder.adaptTo(Node.class)).remove();
                        log.debug("Removed empty workflow folder node [ {} ]", (Object)folder.getPath());
                        ++count;
                    }
                    catch (RepositoryException e) {
                        log.error("Could not remove workflow folder at [ {} ]", (Object)folder.getPath(), (Object)e);
                    }
                }
                this.complete(resourceResolver, checkedCount, workflowRemovedCount);
            }
        }
        catch (PersistenceException e) {
            this.forceQuit.set(false);
            log.error("Error persisting changes with Workflow Removal", (Throwable)e);
            this.error(resourceResolver);
            throw e;
        }
        catch (WorkflowRemovalException e) {
            this.forceQuit.set(false);
            log.error("Error with Workflow Removal", (Throwable)e);
            this.error(resourceResolver);
            throw e;
        }
        catch (InterruptedException e) {
            this.forceQuit.set(false);
            log.error("Errors in persistence retries during Workflow Removal", (Throwable)e);
            this.error(resourceResolver);
            throw e;
        }
        catch (WorkflowRemovalForceQuitException e) {
            this.forceQuit.set(false);
            log.warn("Workflow removal was force quit. The removal state is unknown.");
            this.forceQuit(resourceResolver);
            throw e;
        }
        catch (WorkflowRemovalMaxDurationExceededException e) {
            log.warn("Workflow removal exceeded max duration of [ {} ] minutes. Final removal commit initiating...", (Object)maxDurationInMins);
            this.complete(resourceResolver, checkedCount, count);
        }
        if (log.isInfoEnabled()) {
            log.info("Workflow Removal Process Finished! Removed a total of [ {} ] workflow instances in [ {} ] ms", (Object)count, (Object)(System.currentTimeMillis() - start));
        }
        return count;
    }

    private Collection<Resource> getSortedAndFilteredFolders(Resource folderResource) {
        TreeSet<Resource> sortedCollection = new TreeSet<Resource>(new WorkflowInstanceFolderComparator());
        for (Resource folder : folderResource.getChildren()) {
            if (!folder.isResourceType(NT_SLING_FOLDER) || this.isWorkflowServerFolder(folder)) continue;
            sortedCollection.add(folder);
        }
        return sortedCollection;
    }

    private void save(ResourceResolver resourceResolver) throws PersistenceException, InterruptedException {
        int count = 0;
        while (count++ <= 5) {
            try {
                if (resourceResolver.hasChanges()) {
                    long start = System.currentTimeMillis();
                    resourceResolver.commit();
                    log.debug("Saving batch workflow instance removal in [ {} ] ms", (Object)(System.currentTimeMillis() - start));
                }
                return;
            }
            catch (PersistenceException ex) {
                if (count <= 5) {
                    resourceResolver.refresh();
                    log.warn("Could not persist Workflow Removal changes, trying again in {} ms", (Object)(1000 * count));
                    Thread.sleep(1000 * count);
                    continue;
                }
                throw ex;
            }
        }
    }

    private void start(ResourceResolver resourceResolver) throws PersistenceException, WorkflowRemovalException, InterruptedException {
        this.forceQuit.set(false);
        boolean running = false;
        WorkflowRemovalStatus localStatus = this.getStatus();
        if (localStatus != null) {
            running = localStatus.isRunning();
        }
        if (running) {
            log.warn("Unable to start workflow instance removal; Workflow removal already running.");
            throw new WorkflowRemovalException("Workflow removal already started by " + this.getStatus().getInitiatedBy());
        }
        this.status.set(new WorkflowRemovalStatus(resourceResolver));
        log.info("Starting workflow instance removal");
    }

    private void batchComplete(ResourceResolver resourceResolver, int checked, int count) throws PersistenceException, InterruptedException {
        this.save(resourceResolver);
        WorkflowRemovalStatus status = this.status.get();
        status.setChecked(checked);
        status.setRemoved(count);
        this.status.set(status);
    }

    private void complete(ResourceResolver resourceResolver, int checked, int count) throws PersistenceException, InterruptedException {
        this.save(resourceResolver);
        WorkflowRemovalStatus status = this.status.get();
        status.setRunning(false);
        status.setChecked(checked);
        status.setRemoved(count);
        status.setCompletedAt(Calendar.getInstance());
        this.status.set(status);
    }

    private void error(ResourceResolver resourceResolver) throws PersistenceException, InterruptedException {
        WorkflowRemovalStatus status = this.status.get();
        status.setRunning(false);
        status.setErredAt(Calendar.getInstance());
        this.status.set(status);
    }

    private void forceQuit(ResourceResolver resourceResolver) {
        WorkflowRemovalStatus status = this.status.get();
        status.setRunning(false);
        status.setForceQuitAt(Calendar.getInstance());
        this.status.set(status);
        this.forceQuit.set(false);
    }

    private List<Resource> getWorkflowInstanceFolders(ResourceResolver resourceResolver) {
        ArrayList<Resource> folders = new ArrayList<Resource>();
        Resource root = resourceResolver.getResource("/etc/workflow/instances");
        Iterator itr = root.listChildren();
        boolean addedRoot = false;
        while (itr.hasNext()) {
            Resource resource = (Resource)itr.next();
            if (this.isWorkflowServerFolder(resource)) {
                folders.add(resource);
                continue;
            }
            if (addedRoot || !this.isWorkflowDatedFolder(resource)) continue;
            folders.add(root);
            addedRoot = true;
        }
        if (folders.isEmpty()) {
            folders.add(root);
        }
        return folders;
    }

    private boolean isWorkflowDatedFolder(Resource resource) {
        return NN_DATE_FOLDER_PATTERN.matcher(resource.getName()).matches();
    }

    private boolean isWorkflowServerFolder(Resource folder) {
        return NN_SERVER_FOLDER_PATTERN.matcher(folder.getName()).matches();
    }

    @Activate
    @Deactivate
    protected void reset(Map<String, Object> config) {
        this.forceQuit.set(false);
    }
}

